const models = require('../models/configuracoes')
const response = require("../constants/response");
const yup = require('yup')
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices");


module.exports.getConfiguracoes = async function(req, res, next) {
  try{

    logger("SERVIDOR:Configuracoes").info("Buscar clientes")
    const {pagina, limite, nome_empresa = '', nif = '', email = '', entidade = '', responsavel = ''} = req.query
    const results = await models.getConfiguracoes(pagina, limite, nome_empresa, nif, email, entidade, responsavel); 
    res.status(results.statusCode).json(results)
    
  } catch (error) {
    console.error(error.message)
    logger("SERVIDOR:Configuracoes").error(`Erro ao buscar clientes ${error.message}`)
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getConfiguracoesEntidade = async function(req, res, next) {
  try{
    const {entidade} = req.params
    const results = await models.getConfiguracoesEntidade(entidade)
    res.status(results.statusCode).json(results)
    
  } catch (error) {
    console.error(error.message)
    const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
    res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.configurarWebhook = async function(req, res, next) {   
      try {

        logger("SERVIDOR:configurarWebhook").info(`Inciando a configuração`)
        const {id_clientes} = req.params
        const dados = req.body

        const schemaWebhook = yup.object().shape({
          estado: yup.mixed().oneOf(['true', 'false'])
        })

        logger("SERVIDOR:configurarWebhook").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaWebhook.validate(dados)

        const result = await models.configurarWebhook(id_clientes, validar.estado, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)
        if(result.status == "sucesso"){          
          sendRequestOnMicroservices({lg, nt, wk})
        }

      } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:configurarWebhook").error(`Erro ao configurar acesso ao webhook ${error.message}`)

        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
      }
    
}

module.exports.configurarSMS = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarSMS").info(`Inciando a configuração`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaSMS = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarSMS").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaSMS.validate(dados)

          const result = await models.configurarSMS(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)          
          logger("SERVIDOR:configurarSMS").error(`Erro ao configurar acesso a sms ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarEMAIL = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarEMAIL").info(`Inciando a configuração`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaSMS = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarEMAIL").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaSMS.validate(dados)

          const result = await models.configurarEMAIL(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)          
          logger("SERVIDOR:configurarEMAIL").error(`Erro ao configurar acesso a emails ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarIPS = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarIPS").info(`Inciando a configuração`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaIPS = yup.object().shape({
            ip_primario: yup.mixed().oneOf(['true', 'false']),
            ip_secundario: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarIPS").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaIPS.validate(dados)

          const result = await models.configurarIPS(id_clientes, validar.ip_primario, validar.ip_secundario, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:configurarIPS").error(`Erro ao configurar ips ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarPagamentoRealTime = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarPagamentoRealTime").info(`Iniciando o acesso ao reatTime`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaPagamentoRealTime = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarPagamentoRealTime").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaPagamentoRealTime.validate(dados)

          const result = await models.configurarPagamentoRealTime(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:configurarPagamentoRealTime").error(`Erro ao configurar realTime ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarDefinicoesPaginasDocs = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarDefinicoesPaginasDocs").info(`Iniciando o acesso ao reatTime`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaDefinicoesPaginasDocs = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarDefinicoesPaginasDocs").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaDefinicoesPaginasDocs.validate(dados)
          const result = await models.configurarDefinicoesPaginasDocs(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:configurarDefinicoesPaginasDocs").error(`Erro ao configurar as paginas de documentação ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarDefinicoesPaginasConfiguracaoTecnica = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").info(`Iniciando o acesso as paginas dos tecnicos`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaConfiguracaoTecnica = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaConfiguracaoTecnica.validate(dados)
          const result = await models.configurarDefinicoesPaginasConfiguracaoTecnica(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").error(`Erro ao configurar as paginas dos tecnicos ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarDefinicoesPaginasConfiguracaoPRT = async function(req, res, next) {  
  try {
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").info(`Iniciando o acesso as colunas prt na tabela de pagamentos`)
      const {id_clientes} = req.params
      const dados = req.body

      const schemaConfiguracaoPRT = yup.object().shape({
        estado: yup.mixed().oneOf(['true', 'false'])
      })

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaConfiguracaoPRT.validate(dados)
      const result = await models.configurarDefinicoesPaginasConfiguracaoPRT(id_clientes, validar.estado, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){          
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").error(`Erro ao configurar as colunas prt na tabela de pagamentos ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }

}

module.exports.configurarDefinicoesPaginasConfiguracaoMFT = async function(req, res, next) {  
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").info(`Iniciando o acesso as colunas mft na tabela de pagamentos`)
      const {id_clientes} = req.params
      const dados = req.body

      const schemaConfiguracaoMFT = yup.object().shape({
        estado: yup.mixed().oneOf(['true', 'false'])
      })

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaConfiguracaoMFT.validate(dados)
      const result = await models.configurarDefinicoesPaginasConfiguracaoMFT(id_clientes, validar.estado, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){          
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").error(`Erro ao configurar as colunas mft na tabela de pagamentos ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }

}

module.exports.configurarDefinicoesPaginasConfiguracaoConcliacao = async function(req, res, next) {  
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").info(`Iniciando o acesso as colunas conciliação na tabela de pagamentos`)
      const {id_clientes} = req.params
      const dados = req.body

      const schemaConfiguracaoConcliacao = yup.object().shape({
        estado: yup.mixed().oneOf(['true', 'false'])
      })

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaConfiguracaoConcliacao.validate(dados)
      const result = await models.configurarDefinicoesPaginasConfiguracaoConcliacao(id_clientes, validar.estado, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)
      if(result.status == "sucesso"){          
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").error(`Erro ao configurar as colunas conciliação na tabela de pagamentos ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }

}

module.exports.configurarServicoGPO = async function(req, res, next) {  
      try {

          logger("SERVIDOR:configurarServicoGPO").info(`Iniciando o acesso ao serviço GPO`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaServicoGPO = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarServicoGPO").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaServicoGPO.validate(dados)
          const result = await models.configurarServicoGPO(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:configurarServicoGPO").error(`Erro ao configurar o serviço GPO ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}

module.exports.configurarServicoPagamentoPorSector = async function(req, res, next) {  
      try {
          logger("SERVIDOR:configurarServicoPagamentoPorSector").info(`Iniciando o acesso ao serviço pagamento por sector`)
          const {id_clientes} = req.params
          const dados = req.body

          const schemaServicoPagamentoPorSector = yup.object().shape({
            estado: yup.mixed().oneOf(['true', 'false'])
          })

          logger("SERVIDOR:configurarServicoPagamentoPorSector").debug(`Á validar os dados ${JSON.stringify(dados)}`)
          const validar = await schemaServicoPagamentoPorSector.validate(dados)
          const result = await models.configurarServicoPagamentoPorSector(id_clientes, validar.estado, req)

          var wk = result.webhook
          var lg = result.logs
          var nt = result.notification
          
          delete result.webhook
          delete result.logs
          delete result.notification
          
          res.status(result.statusCode).json(result)
          if(result.status == "sucesso"){          
            sendRequestOnMicroservices({lg, nt, wk})
          }

      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:configurarServicoPagamentoPorSector").error(`Erro ao configurar o serviço pagamento por sector ${error.message}`)

          if(error?.path){
            const rs = response("erro", 412, error.message);
            res.status(rs.statusCode).json(rs)        
          }else{  
            const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
            res.status(rs.statusCode).json(rs)
          }
      }
    
}