const models = require('../models/factura')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getFactura = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getFactura").info("Buscar os dados")
      
      const {pagina, limite, total_registros, numeroFactura = '', valorTotal = '', statusFactura = '', dataVencimento = '', dataPagamento = '', formaPagamento = '', descricao = '', dataEmissao = ''} = req.query
      const results = await models.getFactura(pagina, limite, total_registros, numeroFactura, valorTotal, statusFactura, dataVencimento, dataPagamento, formaPagamento, descricao, dataEmissao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFactura").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getFacturaId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaId").info("Buscar os dados")
      const {facturaId} = req.params
      const results = await models.getFacturaId(facturaId)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getFacturaclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaclienteId").info("Buscar os dados")
      const {clienteId} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getFacturaclienteId(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getFacturaEntidadeclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaEntidadeclienteId").info("Buscar os dados")
      const {empresaId, clienteId} = req.params
      const {pagina, limite, total_registros, numeroFactura = '', valorTotal = '', statusFactura = '', dataVencimento = '', dataPagamento = '', formaPagamento = '', descricao = '', dataEmissao = ''} = req.query
      const results = await models.getFacturaEntidadeclienteId(empresaId, clienteId, pagina, limite, total_registros, numeroFactura, valorTotal, statusFactura, dataVencimento, dataPagamento, formaPagamento, descricao, dataEmissao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaEntidadeclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getFacturaEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaEntidadeGrupoAfiliados").info("Buscar os dados")
      const {empresaId, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getFacturaEntidadeGrupoAfiliados(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getFacturaEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaEntidade").info("Buscar os dados")
      const {empresaId} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora_transacao = '', data_transacao = ''} = req.query
      const results = await models.getFacturaEntidade(empresaId, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getFacturaPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaEntidade").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getFacturaPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getFacturaEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {empresaId,periodo} = req.params
      const results = await models.getFacturaEntidadePeriodo(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getFacturaEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaEntidadeDias").info("Buscar os dados")
      const {empresaId, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getFacturaEntidadeDias(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
module.exports.getFacturaDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getFacturaDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getFacturaDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getFacturaDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}