const models = require('../models/marcacoes_assessoria')
const bcrypt = require('bcryptjs');
const yup = require('yup')
const logger = require('../services/loggerService'); 
const response = require("../constants/response");
const moment = require("moment");
const { parse, isDate } = require("date-fns");
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices");

function parseDateString(value, originalValue) {
  const parsedDate = isDate(new Date(originalValue))
    ? new Date(originalValue)
    : parse(originalValue, "yyyy-MM-dd", new Date());

  return parsedDate;
}

module.exports.getMarcacoesAssessoria = async function(req, res, next) { 
  try {  
      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {pagina, limite, total_registros, nome = '', email = '', mensagem = '', telefone = '', assunto = '', origem = '', data_pclienteId = '', horario_pclienteId = '', status = '', criacao = ''} = req.query
      const results = await models.getMarcacoesAssessoria(pagina, limite, total_registros, nome, email, mensagem, telefone, assunto, origem, data_pclienteId, horario_pclienteId, status, criacao)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getMarcacoesAssessoriaId = async function(req, res, next) {
  try {  

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {id_marcacoes_assessoria} = req.params
      const results = await models.getMarcacoesAssessoriaId(id_marcacoes_assessoria)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.postMarcacoesAssessoria = async function(req, res, next) {
  try {

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const dados = req.body
      const phoneRegExp = /^((\\+[1-9]{1,4}[ \\-]*)|(\\([0-9]{2,3}\\)[ \\-]*)|([0-9]{2,4})[ \\-]*)*?[0-9]{3,4}?[ \\-]*[0-9]{3,4}?$/
      
      const schemaMarcacoesAssessoria = yup.object().shape({
        nome: yup.string().required(),
        telefone: yup.string().matches(phoneRegExp, 'Phone number is not valid').required(),
        email: yup.string().email().required(),
        mensagem: yup.string().required(),
        assunto: yup.string().required(),
        origem: yup.string().required(),
        data_pclienteId: yup.string().required(),
        horario_pclienteId:yup.string().test(
          "date validation",
          "Invalid date or format. The string should be a valid HH:mm format.",
          val => {
            if (!val) {
              return true;
            }
            return moment(val, "HH:mm", true).isValid();
          }
        ).required(),
        status: yup.mixed().oneOf(['pendente','confirmado','cancelado']).default('0')
      }) 

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaMarcacoesAssessoria.validate(dados)
      
      const result = await models.postMarcacoesAssessoria({...validar}, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)          
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}


module.exports.patchMarcacoesAssessoria = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_marcacoes_assessoria} = req.params
        const dados = req.body
        const phoneRegExp = /^((\\+[1-9]{1,4}[ \\-]*)|(\\([0-9]{2,3}\\)[ \\-]*)|([0-9]{2,4})[ \\-]*)*?[0-9]{3,4}?[ \\-]*[0-9]{3,4}?$/
        
        const schemaMarcacoesAssessoria = yup.object().shape({
          nome: yup.string(),
          telefone: yup.string().matches(phoneRegExp, 'Phone number is not valid'),
          email: yup.string().email(),
          mensagem: yup.string(),
          assunto: yup.string(),
          origem: yup.string(),
          data_pclienteId: yup.string(),
          horario_pclienteId:yup.string().test(
            "date validation",
            "Invalid date or format. The string should be a valid HH:mm format.",
            val => {
              if (!val) {
                return true;
              }
              return moment(val, "HH:mm", true).isValid();
            }
          ),
          status: yup.mixed().oneOf(['pendente','confirmado','cancelado']).default('0')
        }) 

        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaMarcacoesAssessoria.validate(dados)
        
        const result = await models.patchMarcacoesAssessoria(id_marcacoes_assessoria, validar, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }

module.exports.deleteMarcacoesAssessoria = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_marcacoes_assessoria} = req.params
        const result = await models.deleteMarcacoesAssessoria(id_marcacoes_assessoria, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
}