const models = require('../models/produtos')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getProdutos = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getProdutos").info("Buscar os dados")
      
      const {pagina, limite, total_registros, codigoProduto = '', descricao = '', unidadeMedida = '', preco = '', categoria = '', ativo = '', dataProduto = ''} = req.query
      const results = await models.getProdutos(pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutos").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getProdutosId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosId").info("Buscar os dados")
      const {produtoId} = req.params
      const results = await models.getProdutosId(produtoId)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getProdutosclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosclienteId").info("Buscar os dados")
      const {clienteId} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getProdutosclienteId(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getProdutosEntidadeclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosEntidadeclienteId").info("Buscar os dados")
      const {empresaId, clienteId} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getProdutosEntidadeclienteId(empresaId, clienteId, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosEntidadeclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getProdutosEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosEntidadeGrupoAfiliados").info("Buscar os dados")
      const {empresaId, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getProdutosEntidadeGrupoAfiliados(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getProdutosEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosEntidade").info("Buscar os dados")
      const {empresaId} = req.params
      const {pagina, limite, total_registros, codigoProduto = '', descricao = '', unidadeMedida = '', preco = '', categoria = '', ativo = '', dataProduto = ''} = req.query
      const results = await models.getProdutosEntidade(empresaId, pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getProdutosPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosEntidade").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getProdutosPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getProdutosEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {empresaId,periodo} = req.params
      const results = await models.getProdutosEntidadePeriodo(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getProdutosEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosEntidadeDias").info("Buscar os dados")
      const {empresaId, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getProdutosEntidadeDias(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
module.exports.getProdutosDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getProdutosDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getProdutosDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getProdutosDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}