const models = require('../models/solicitacoes_imprensa')
const bcrypt = require('bcryptjs');
const yup = require('yup')
const logger = require('../services/loggerService'); 
const response = require("../constants/response");
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 
const StrengthSchecker = require('../helpers/StrengthSchecker');

module.exports.getSolicitacoesImprensa = async function(req, res, next) { 
  try {  
      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {pagina, limite, total_registros, nome = '', email = '', telefone = '', veiculo_comunicacao = '', necessidade = '', status = '', criacao = ''} = req.query
      const results = await models.getSolicitacoesImprensa(pagina, limite, total_registros, nome, email, telefone, veiculo_comunicacao, necessidade, status, criacao)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getSolicitacoesImprensaId = async function(req, res, next) {
  try {  

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {id_solicitacoes_imprensa} = req.params
      const results = await models.getSolicitacoesImprensaId(id_solicitacoes_imprensa)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.postSolicitacoesImprensa = async function(req, res, next) {
  try {

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const dados = req.body
      const phoneRegExp = /^((\\+[1-9]{1,4}[ \\-]*)|(\\([0-9]{2,3}\\)[ \\-]*)|([0-9]{2,4})[ \\-]*)*?[0-9]{3,4}?[ \\-]*[0-9]{3,4}?$/
      
      const schemaSolicitacoesImprensa = yup.object().shape({
        nome: yup.string().required(),
        telefone: yup.string().matches(phoneRegExp, 'Phone number is not valid').required(),
        email: yup.string().email().required(),
        veiculo_comunicacao: yup.string().required(),
        necessidade: yup.string().required(),
        aceita_email: yup.number().required(),
        aceita_sms: yup.number().required(),
        aceita_whatsapp: yup.number().required(),
        aceita_ligacoes: yup.number().required(),
        status: yup.mixed().oneOf(['pendente','respondido','cancelado']).default('ativo')
      }) 
      

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaSolicitacoesImprensa.validate(dados)
      
      
      const result = await models.postSolicitacoesImprensa({...validar}, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)          
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}


module.exports.patchSolicitacoesImprensa = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_solicitacoes_imprensa} = req.params
        const dados = req.body
        const phoneRegExp = /^((\\+[1-9]{1,4}[ \\-]*)|(\\([0-9]{2,3}\\)[ \\-]*)|([0-9]{2,4})[ \\-]*)*?[0-9]{3,4}?[ \\-]*[0-9]{3,4}?$/
        
        const schemaSolicitacoesImprensa = yup.object().shape({
          nome: yup.string(),
          telefone: yup.string().matches(phoneRegExp, 'Phone number is not valid'),
          email: yup.string().email(),
          veiculo_comunicacao: yup.string(),
          necessidade: yup.string(),
          aceita_email: yup.number(),
          aceita_sms: yup.number(),
          aceita_whatsapp: yup.number(),
          aceita_ligacoes: yup.number(),
          status: yup.mixed().oneOf(['pendente','respondido','cancelado']).default('ativo')
        })

        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaSolicitacoesImprensa.validate(dados)
        
        const result = await models.patchSolicitacoesImprensa(id_solicitacoes_imprensa, validar, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }

module.exports.deleteSolicitacoesImprensa = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_solicitacoes_imprensa} = req.params
        const result = await models.deleteSolicitacoesImprensa(id_solicitacoes_imprensa, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
}