const models = require('../models/tipo_usuario')
const yup = require('yup')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

module.exports.getTipo_usuario = async function(req, res, next) {
    try {  
          logger("SERVIDOR:Clientes").info("Buscar clientes")
          const results = await models.getTipo_usuario(); 
          res.status(results.statusCode).json(results)
    
      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
      }
    
}  

module.exports.getTipo_usuario_usuarios = async function(req, res, next) {
    try {  
          logger("SERVIDOR:Clientes").info("Buscar clientes")
          const {nome_usuario = '', email = '', tipo_nome_usuario = ''} = req.query
          const results = await models.getTipo_usuario_usuarios(nome_usuario, email, tipo_nome_usuario); 
          res.status(results.statusCode).json(results)
    
      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
      }
    
}   

module.exports.getTipo_usuario_usuariosID = async function(req, res, next) {
    try {  
          logger("SERVIDOR:getTipo_usuario_usuariosID").info("Buscar clientes")
          const {id_tipo_usuario} = req.params
          const {nome_usuario = '', email = '', tipo_nome_usuario = ''} = req.query
          const results = await models.getTipo_usuario_usuariosID(id_tipo_usuario, nome_usuario, email, tipo_nome_usuario); 
          res.status(results.statusCode).json(results)
    
      } catch (error) {
          console.error(error.message)
          logger("SERVIDOR:getTipo_usuario_usuariosID").error(`Erro ao buscar clientes ${error.message}`)
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
      }
    
}   

module.exports.postTipo_usuario = async function(req, res, next) {
    try {

        logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`) 
        const dados =  req.body
  
        const schemaTipoUsuario = yup.object().shape({
          tipo_nome_usuario: yup.string().required(),
        })
  
        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaTipoUsuario.validate(dados)
        const result = await models.postTipo_usuario(validar)
        
        var lg = result.logs
        delete result.logs
        
        res.status(result.statusCode).json(result)
                      
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg})
        }
      
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }    
}

module.exports.patchTipo_usuario = async function(req, res, next) {
    try {
        logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
        const {id_tipo_usuario} = req.params
        const dados =  req.body
  
        const schemaTipoUsuario = yup.object().shape({
          tipo_nome_usuario: yup.string().required(),
        })
  
        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaTipoUsuario.validate(dados)
        const result = await models.patchTipo_usuario(id_tipo_usuario, validar)
        
        var lg = result.logs
        delete result.logs
        
        res.status(result.statusCode).json(result)
                      
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg})
        }
      
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }    
}

module.exports.deleteTipo_usuario = async function(req, res, next) {
    try {
          logger("SERVIDOR:postAfiliados").info(`Iniciando cadastrado o afiliado`)        
          const {id_tipo_usuario} = req.params
          
          const result = await models.deleteTipo_usuario(id_tipo_usuario)
          
          var lg = result.logs
          delete result.logs
          
          res.status(result.statusCode).json(result)
                        
          if(result.status == "sucesso"){
            sendRequestOnMicroservices({lg})
          }
        
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }    
}