const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getColaborador = async function(pagina, limite, total_registros, nome_colaborador, cargo_colaborador, email_colaborador, telefone_colaborador, status_colaborador, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const colaboradores = await database("colaboradores")
      .whereLike("nome_colaborador",`%${nome_colaborador}%`)
      .whereLike("cargo_colaborador",`%${cargo_colaborador}%`)
      .whereLike("email_colaborador",`%${email_colaborador}%`)
      .whereLike("telefone_colaborador",`%${telefone_colaborador}%`)
      .whereLike("status_colaborador",`%${status_colaborador}%`)
      .whereLike("data_criacao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_colaborador", "DESC");

      const {registros} = paginationRecords(colaboradores, pagina, limite)

      const colaboradoresLimite = await database("colaboradores")
      .whereLike("nome_colaborador",`%${nome_colaborador}%`)
      .whereLike("cargo_colaborador",`%${cargo_colaborador}%`)
      .whereLike("email_colaborador",`%${email_colaborador}%`)
      .whereLike("telefone_colaborador",`%${telefone_colaborador}%`)
      .whereLike("status_colaborador",`%${status_colaborador}%`)
      .whereLike("data_criacao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_colaborador", "DESC");

      const filtered = usuariosFilteres(colaboradoresLimite)
      
      registros.total_apresentados = colaboradoresLimite.length
      registros.nome = nome_colaborador
      registros.email = email_colaborador
      registros.cargo = cargo_colaborador
      registros.status = status_colaborador
      registros.telefone = telefone_colaborador
      registros.criacao = data_criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getColaboradorId = async function(id_colaborador) {
  try {

      const colaboradores = await database("colaboradores")
      .where({ id_colaborador })
      .orderBy("id_colaborador", "DESC");

      const [filtered] = usuariosFilteres(colaboradores)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postColaborador = async function(dados, req) {
  try {

      const resultTipoReg = await database("colaboradores").where({
        email_colaborador: dados.email_colaborador
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Email já cadastrado!`)
        const rs = response("erro", 409, "Email já cadastrado!");
        return rs
      }

      const resultTelefone = await database("colaboradores").where({
        telefone_colaborador: dados.telefone_colaborador
      });

      if (resultTelefone.length > 0){
        logger("SERVIDOR:postClientes").info(`Telefone já cadastrado!`)
        const rs = response("erro", 409, "Telefone já cadastrado!");
        return rs
      }

      const resultLink = await database("colaboradores").where({
        linkedin: dados.linkedin
      });

      if (resultLink.length > 0){
        logger("SERVIDOR:postClientes").info(`Likendin já cadastrado!`)
        const rs = response("erro", 409, "Likendin já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("colaboradores").insert(dados);
      logger("SERVIDOR:Clientes").info(`Colaborador cadastrado com sucesso`)
      const rs = response("sucesso", 201, "Colaborador cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchColaborador = async function(id_colaborador, dados, req) {
  try {

      const result = await database("colaboradores")
      .where({id_colaborador});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("Colaborador não encontrados")
        const rs = response("erro", 403, "Colaborador não encontrados");
        return rs

      }

      await database("colaboradores")
        .where({ id_colaborador })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_colaborador, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteColaborador = async function(id_colaborador, req) {
  try {

      const dados = await database("colaboradores").where({ id_colaborador })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("Colaborador não encontrados")
        const rs = response("erro", 403, "Colaborador não encontrados");
        return rs

      }

      await database("colaboradores").where({ id_colaborador }).del();

      logger("SERVIDOR:loginClientes").info("Colaborador excluido feita com sucesso") 
      const rs = response("sucesso", 202, "Colaborador excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_colaborador, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
