const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getContatoMensagens = async function(pagina, limite, total_registros,  nome, lido, email, mensagem, telefone, assunto, criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const contato_mensagens = await database("contato_mensagens")
      .whereLike("nome",`%${nome}%`)
      .whereLike("lido",`%${lido}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("mensagem",`%${mensagem}%`)
      .whereLike("assunto",`%${assunto}%`)
      .whereLike("data_envio",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_contato_mensagens", "DESC");

      const {registros} = paginationRecords(contato_mensagens, pagina, limite)

      const contato_mensagensLimite = await database("contato_mensagens")
      .whereLike("nome",`%${nome}%`)
      .whereLike("lido",`%${lido}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("mensagem",`%${mensagem}%`)
      .whereLike("assunto",`%${assunto}%`)
      .whereLike("data_envio",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_contato_mensagens", "DESC");

      const filtered = usuariosFilteres(contato_mensagensLimite)
      
      registros.total_apresentados = contato_mensagensLimite.length
      registros.nome = nome
      registros.email = email
      registros.lido = lido
      registros.assunto = assunto
      registros.telefone = mensagem
      registros.mensagem = mensagem
      registros.criacao = criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getContatoMensagensId = async function(id_contato_mensagens) {
  try {

      const contato_mensagens = await database("contato_mensagens")
      .where({ id_contato_mensagens })
      .orderBy("id_contato_mensagens", "DESC");

      const [filtered] = usuariosFilteres(contato_mensagens)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postContatoMensagens = async function(dados, req) {
  try {


      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("contato_mensagens").insert(dados);
      logger("SERVIDOR:Clientes").info(`ContatoMensagens cadastrado com sucesso`)
      const rs = response("sucesso", 201, "ContatoMensagens cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchContatoMensagens = async function(id_contato_mensagens, dados, req) {
  try {

      const result = await database("contato_mensagens")
      .where({id_contato_mensagens});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("ContatoMensagens não encontrados")
        const rs = response("erro", 403, "ContatoMensagens não encontrados");
        return rs

      }

      await database("contato_mensagens")
        .where({ id_contato_mensagens })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_contato_mensagens, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteContatoMensagens = async function(id_contato_mensagens, req) {
  try {

      const dados = await database("contato_mensagens").where({ id_contato_mensagens })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("ContatoMensagens não encontrados")
        const rs = response("erro", 403, "ContatoMensagens não encontrados");
        return rs

      }

      await database("contato_mensagens").where({ id_contato_mensagens }).del();

      logger("SERVIDOR:loginClientes").info("ContatoMensagens excluido feita com sucesso") 
      const rs = response("sucesso", 202, "ContatoMensagens excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_contato_mensagens, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
