const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getConteudoSobreNós = async function(pagina, limite, total_registros) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const conteudo_sobre_nos = await database("conteudo_sobre_nos")
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_conteudo_sobre_nos", "DESC");

      const {registros} = paginationRecords(conteudo_sobre_nos, pagina, limite)

      const conteudo_sobre_nosLimite = await database("conteudo_sobre_nos")
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_conteudo_sobre_nos", "DESC");

      const filtered = usuariosFilteres(conteudo_sobre_nosLimite)
      
      registros.total_apresentados = conteudo_sobre_nosLimite.length

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getConteudoSobreNósId = async function(id_conteudo_sobre_nos) {
  try {

      const conteudo_sobre_nos = await database("conteudo_sobre_nos")
      .where({ id_conteudo_sobre_nos })
      .orderBy("id_conteudo_sobre_nos", "DESC");

      const [filtered] = usuariosFilteres(conteudo_sobre_nos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postConteudoSobreNós = async function(dados, req) {
  try {

      const resultTipoReg = await database("conteudo_sobre_nos").where({
        titulo: dados.titulo
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Titulo já cadastrado!`)
        const rs = response("erro", 409, "Titulo já cadastrado!");
        return rs
      }

      const resultSubititulo = await database("conteudo_sobre_nos").where({
        subtitulo: dados.subtitulo
      });

      if (resultSubititulo.length > 0){
        logger("SERVIDOR:postClientes").info(`Subititulo já cadastrado!`)
        const rs = response("erro", 409, "Subititulo já cadastrado!");
        return rs
      }

      const resultLink = await database("conteudo_sobre_nos").where({
        conteudo: dados.conteudo
      });

      if (resultLink.length > 0){
        logger("SERVIDOR:postClientes").info(`Conteudo já cadastrado!`)
        const rs = response("erro", 409, "Conteudo já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("conteudo_sobre_nos").insert(dados);
      logger("SERVIDOR:Clientes").info(`ConteudoSobreNós cadastrado com sucesso`)
      const rs = response("sucesso", 201, "ConteudoSobreNós cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchConteudoSobreNós = async function(id_conteudo_sobre_nos, dados, req) {
  try {

      const result = await database("conteudo_sobre_nos")
      .where({id_conteudo_sobre_nos});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("ConteudoSobreNós não encontrados")
        const rs = response("erro", 403, "ConteudoSobreNós não encontrados");
        return rs

      }

      await database("conteudo_sobre_nos")
        .where({ id_conteudo_sobre_nos })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_conteudo_sobre_nos, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteConteudoSobreNós = async function(id_conteudo_sobre_nos, req) {
  try {

      const dados = await database("conteudo_sobre_nos").where({ id_conteudo_sobre_nos })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("ConteudoSobreNós não encontrados")
        const rs = response("erro", 403, "ConteudoSobreNós não encontrados");
        return rs

      }

      await database("conteudo_sobre_nos").where({ id_conteudo_sobre_nos }).del();

      logger("SERVIDOR:loginClientes").info("ConteudoSobreNós excluido feita com sucesso") 
      const rs = response("sucesso", 202, "ConteudoSobreNós excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_conteudo_sobre_nos, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
