const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getConteudoSobreNosBloco = async function(pagina, limite, total_registros, tipo, titulo, conteudo, status, ordem) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const conteudo_sobre_nos_blocos = await database("conteudo_sobre_nos_blocos")
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("titulo",`%${titulo}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("order",`%${ordem}%`)
      .whereLike("status",`%${status}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_conteudo_sobre_nos_blocos", "DESC");

      const {registros} = paginationRecords(conteudo_sobre_nos_blocos, pagina, limite)

      const conteudo_sobre_nos_blocosLimite = await database("conteudo_sobre_nos_blocos")
      .whereLike("tipo",`%${tipo}%`)
      .whereLike("titulo",`%${titulo}%`)
      .whereLike("conteudo",`%${conteudo}%`)
      .whereLike("order",`%${ordem}%`)
      .whereLike("status",`%${status}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_conteudo_sobre_nos_blocos", "DESC");

      const filtered = usuariosFilteres(conteudo_sobre_nos_blocosLimite)
      
      registros.total_apresentados = conteudo_sobre_nos_blocosLimite.length
      registros.tipo = tipo
      registros.conteudo = conteudo
      registros.titulo = titulo
      registros.status = status
      registros.ordem = ordem

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getConteudoSobreNosBlocoId = async function(id_conteudo_sobre_nos_blocos) {
  try {

      const conteudo_sobre_nos_blocos = await database("conteudo_sobre_nos_blocos")
      .where({ id_conteudo_sobre_nos_blocos })
      .orderBy("id_conteudo_sobre_nos_blocos", "DESC");

      const [filtered] = usuariosFilteres(conteudo_sobre_nos_blocos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postConteudoSobreNosBloco = async function(dados, req) {
  try {

      const resultTipoReg = await database("conteudo_sobre_nos_blocos").where({
        conteudo: dados.conteudo,
        tipo: dados.tipo
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Conteudo já cadastrado!`)
        const rs = response("erro", 409, "Conteudo já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Conteudo criado com sucesso`)
      await database("conteudo_sobre_nos_blocos").insert(dados);
      logger("SERVIDOR:Clientes").info(`ConteudoSobreNosBloco cadastrado com sucesso`)
      const rs = response("sucesso", 201, "ConteudoSobreNosBloco cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchConteudoSobreNosBloco = async function(id_conteudo_sobre_nos_blocos, dados, req) {
  try {

      const result = await database("conteudo_sobre_nos_blocos")
      .where({id_conteudo_sobre_nos_blocos});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("ConteudoSobreNosBloco não encontrados")
        const rs = response("erro", 403, "ConteudoSobreNosBloco não encontrados");
        return rs

      }

      await database("conteudo_sobre_nos_blocos")
        .where({ id_conteudo_sobre_nos_blocos })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_conteudo_sobre_nos_blocos, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteConteudoSobreNosBloco = async function(id_conteudo_sobre_nos_blocos, req) {
  try {

      const dados = await database("conteudo_sobre_nos_blocos").where({ id_conteudo_sobre_nos_blocos })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("ConteudoSobreNosBloco não encontrados")
        const rs = response("erro", 403, "ConteudoSobreNosBloco não encontrados");
        return rs

      }

      await database("conteudo_sobre_nos_blocos").where({ id_conteudo_sobre_nos_blocos }).del();

      logger("SERVIDOR:loginClientes").info("ConteudoSobreNosBloco excluido feita com sucesso") 
      const rs = response("sucesso", 202, "ConteudoSobreNosBloco excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_conteudo_sobre_nos_blocos, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
