const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getCursosInscricoes = async function(pagina, limite, total_registros, nome, email, telefone, status, data_inscricao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const cursos_inscricoes = await database("cursos_inscricoes")
      .whereLike("nome",`%${nome}%`)      
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_inscricao",`%${data_inscricao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_cursos_inscricoes", "DESC");

      const {registros} = paginationRecords(cursos_inscricoes, pagina, limite)

      const cursos_inscricoesLimite = await database("cursos_inscricoes")
      .whereLike("nome",`%${nome}%`)      
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_inscricao",`%${data_inscricao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_cursos_inscricoes", "DESC");

      const filtered = usuariosFilteres(cursos_inscricoesLimite)
      
      registros.total_apresentados = cursos_inscricoesLimite.length
      registros.nome = nome
      registros.email = email
      registros.status = status
      registros.telefone = telefone
      registros.criacao = data_inscricao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getCursosInscricoesId = async function(id_cursos_inscricoes) {
  try {

      const cursos_inscricoes = await database("cursos_inscricoes")
      .where({ id_cursos_inscricoes })
      .orderBy("id_cursos_inscricoes", "DESC");

      const [filtered] = usuariosFilteres(cursos_inscricoes)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postCursosInscricoes = async function(dados, req) {
  try {

      const resultTipoReg = await database("cursos_inscricoes").where({
        curso_id: dados.curso_id,
        estudante_id: dados.estudante_id
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Estudante já inscrito!`)
        const rs = response("erro", 409, "Estudante já inscrito!");
        return rs
      }

      const resultTCurso = await database("cursos").where({
        id_cursos: dados.curso_id
      });

      if (!resultTCurso.length){
        logger("SERVIDOR:postClientes").info(`Curso não cadastrado!`)
        const rs = response("erro", 409, "Curso não cadastrado!");
        return rs
      }

      const resultEstudante = await database("estudantes").where({
        id_estudantes: dados.estudante_id
      });

      if (!resultEstudante.length){
        logger("SERVIDOR:postClientes").info(`Estudante não encontrado!`)
        const rs = response("erro", 409, "Estudante não encontrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("cursos_inscricoes").insert(dados);
      logger("SERVIDOR:Clientes").info(`CursosInscricoes cadastrado com sucesso`)
      const rs = response("sucesso", 201, "CursosInscricoes cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchCursosInscricoes = async function(id_cursos_inscricoes, dados, req) {
  try {

      const result = await database("cursos_inscricoes")
      .where({id_cursos_inscricoes});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("CursosInscricoes não encontrados")
        const rs = response("erro", 403, "CursosInscricoes não encontrados");
        return rs

      }

      await database("cursos_inscricoes")
        .where({ id_cursos_inscricoes })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_cursos_inscricoes, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteCursosInscricoes = async function(id_cursos_inscricoes, req) {
  try {

      const dados = await database("cursos_inscricoes").where({ id_cursos_inscricoes })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("CursosInscricoes não encontrados")
        const rs = response("erro", 403, "CursosInscricoes não encontrados");
        return rs

      }

      await database("cursos_inscricoes").where({ id_cursos_inscricoes }).del();

      logger("SERVIDOR:loginClientes").info("CursosInscricoes excluido feita com sucesso") 
      const rs = response("sucesso", 202, "CursosInscricoes excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_cursos_inscricoes, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
