const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const {pedidoCotacaoFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getDashboard = async function(pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req) {
     
    try{

        logger("SERVIDOR:getDashboard").debug("Á carregar dados")
        const produto = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')

        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getDashboard").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")  
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')
        
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.codigoProduto = codigoProduto
        registros.descricao = descricao
        registros.unidadeMedida = unidadeMedida
        registros.preco = preco
        registros.categoria = categoria
        registros.ativo = ativo
        registros.dataProduto = dataProduto

        delete registros.count

        logger("SERVIDOR:getDashboard").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs

    
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboard").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}


module.exports.getDashboardId = async function(produtoId) {
     
     try{

        logger("SERVIDOR:getDashboardId").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .where({produtoId})
        .orderBy('produtoId','desc')
        
        const [filtered] = pedidoCotacaoFilteres(produto)

        logger("SERVIDOR:getDashboardId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered || {});            
        return rs      
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getDashboardclienteId = async function(empresaId, clienteId, ano) {
     
     try{

        logger("SERVIDOR:getDashboardclienteId").debug("Á carregar dados")
        const facturas_recentes = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .limit(5)

        const [numero_facturas] = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .count("facturaId as numero_facturas")

        const [ultima_factura_emitida] = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .andWhere({statusFactura: "Emitida"})
        .limit(1)
        .orderBy("facturaId","DESC")

        const [total_facturas_emitidas] = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .andWhere({statusFactura: "Emitida"})
        .sum("valorTotalFactura as total_facturas_emitidas")

        const [total_facturas_pagas] = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .andWhere({statusFactura: "Paga"})
        .sum("valorTotalFactura as total_facturas_pagas")

        const [total_facturas_canceladas] = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .andWhere({statusFactura: "Cancelada"})
        .sum("valorTotalFactura as total_facturas_canceladas")

        const [total_facturas_vencidas] = await database('factura')
        .where({clienteIdFac: clienteId})
        .andWhere({empresaIdFac: empresaId})
        .andWhere({statusFactura: "Vencida"})
        .sum("valorTotalFactura as total_facturas_vencidas")
        
        const [numero_pedidos_aceites] = await database('pedidocotacao')
        .where({clienteIdPedido: clienteId})
        .andWhere({empresaID: empresaId})
        .andWhere({statusPedido: "Aprovado"})
        .count("pedidoCotacaoId as numero_pedidos_aceites")

        const [numero_pedidos_cancelados] = await database('pedidocotacao')
        .where({clienteIdPedido: clienteId})
        .andWhere({empresaID: empresaId})
        .andWhere({statusPedido: "Rejeitado"})
        .count("pedidoCotacaoId as numero_pedidos_cancelados")

        const [numero_produtos] = await database('produto')
        .where({empresaDona: empresaId})
        .count("produtoId as numero_produtos")

        const movimento_financeiro = await database('movimento_financeiro')
        .where({clienteIdMov: clienteId})
        .andWhere({referenciaTipo: 'Débito'})
        .orWhere({referenciaTipo: 'Depósito'})
        .andWhere({empresaIdMov: empresaId})
        .limit(6)
        .orderBy("movimentoFinanceiroId","DESC")


        const cards = {
          ...numero_facturas,
          ...numero_pedidos_aceites,
          ...numero_pedidos_cancelados,
          ...numero_produtos
        }

        const facturas_actividades = {
          ultima_factura_emitida,
          total_valores_de_facturas :{
            ...total_facturas_emitidas,
            ...total_facturas_pagas,
            ...total_facturas_canceladas,
            ...total_facturas_vencidas
          }
        }

        const facturas_recentes_e_transacoes = {
            facturas_recentes,
            movimento_financeiro
        }

        const dash = {
          cards,
          facturas_actividades,
          facturas_recentes_e_transacoes
        }

        logger("SERVIDOR:getDashboardclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, dash, "json");
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getDashboardEntidadeclienteId = async function(empresaId, clienteId, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getDashboardEntidadeclienteId").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getDashboardEntidadeclienteId").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getDashboardEntidadeclienteId").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({clienteId_do_servico: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')
      
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getDashboardEntidadeclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({clienteId_do_servico: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getDashboardEntidadeclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getDashboardEntidadeGrupoAfiliados = async function(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getDashboardEntidadeGrupoAfiliados").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getDashboardEntidadeGrupoAfiliados").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')

        const {registros} = paginationRecords(produto, pagina, limite)

        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')
      
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getDashboardEntidadeGrupoAfiliados").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardEntidadeGrupoAfiliados").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getDashboardEntidade = async function(empresaId, pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req) {
     
     try{

        logger("SERVIDOR:getDashboardEntidade").debug("Á carregar dados de configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if((verifivarPagamentoTempoReal?.servico_principal == "false")){
          logger("SERVIDOR:loginClientes").warn("Serviço de gestão inactivo")
          const rs = response("erro", 423, "Serviço de gestão inactivo");
          return rs     
        }

        logger("SERVIDOR:getDashboardEntidade").debug("Á carregar dados")
        const produto = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .where({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')    
      
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getDashboardEntidade").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .where({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.codigoProduto = codigoProduto
        registros.descricao = descricao
        registros.unidadeMedida = unidadeMedida
        registros.preco = preco
        registros.categoria = categoria
        registros.ativo = ativo
        registros.dataProduto = dataProduto

        delete registros.count

        logger("SERVIDOR:getDashboardEntidade").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardEntidade").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getDashboardPeriodo = async function(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getDashboardPeriodo").debug("Á carregar dados")
      const produto = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('produtoId','desc')  
              
      const {registros} = paginationRecords(produto, pagina, limite)

      logger("SERVIDOR:getDashboardPeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('produtoId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getDashboardPeriodo").info("Respondeu a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getDashboardPeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getDashboardEntidadePeriodo = async function(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getDashboardEntidadePeriodo").debug("Á carregar dados da configuração")
      const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

      if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
        logger("SERVIDOR:getDashboardEntidadePeriodo").info("Serviço de pagamento por sector inactivo")
        const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
        return rs
      }

      logger("SERVIDOR:getDashboardEntidadePeriodo").debug("Á carregar dados")
      const produto = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('produtoId','desc')  
              
      const {registros} = paginationRecords(produto, pagina, limite)

      logger("SERVIDOR:getDashboardEntidadePeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('produtoId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = empresaId
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getDashboardEntidadePeriodo").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getDashboardEntidadePeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getDashboardEntidadeDias = async function(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getDashboardEntidadeDias").debug("Á carregar dados da configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getDashboardEntidadeDias").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getDashboardEntidadeDias").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')          
        
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getDashboardEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora
  
        logger("SERVIDOR:getDashboardEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardEntidadeDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getDashboardDias = async function(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{
      
        logger("SERVIDOR:getDashboardEntidadeDias").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')          
        
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getDashboardEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        logger("SERVIDOR:getDashboardEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getDashboardEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}
