const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getMarcacoesAssessoria = async function(pagina, limite, total_registros,  nome, email, mensagem, telefone, assunto, origem, data_pclienteId, horario_pclienteId, status, criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const marcacoes_assessoria = await database("marcacoes_assessoria")
      .whereLike("nome",`%${nome}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("mensagem",`%${mensagem}%`)
      .whereLike("assunto",`%${assunto}%`)
      .whereLike("origem",`%${origem}%`)
      .whereLike("data_pclienteId",`%${data_pclienteId}%`)
      .whereLike("horario_pclienteId",`%${horario_pclienteId}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_envio",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_marcacoes_assessoria", "DESC");

      const {registros} = paginationRecords(marcacoes_assessoria, pagina, limite)

      const marcacoes_assessoriaLimite = await database("marcacoes_assessoria")
      .whereLike("nome",`%${nome}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("mensagem",`%${mensagem}%`)
      .whereLike("assunto",`%${assunto}%`)
      .whereLike("origem",`%${origem}%`)
      .whereLike("data_pclienteId",`%${data_pclienteId}%`)
      .whereLike("horario_pclienteId",`%${horario_pclienteId}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_envio",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_marcacoes_assessoria", "DESC");

      const filtered = usuariosFilteres(marcacoes_assessoriaLimite)
      
      registros.total_apresentados = marcacoes_assessoriaLimite.length
      registros.nome = nome
      registros.email = email
      registros.assunto = assunto
      registros.telefone = mensagem
      registros.mensagem = mensagem
      registros.origem = origem
      registros.data_pclienteId = data_pclienteId
      registros.horario_pclienteId = horario_pclienteId
      registros.status = status
      registros.criacao = criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getMarcacoesAssessoriaId = async function(id_marcacoes_assessoria) {
  try {

      const marcacoes_assessoria = await database("marcacoes_assessoria")
      .where({ id_marcacoes_assessoria })
      .orderBy("id_marcacoes_assessoria", "DESC");

      const [filtered] = usuariosFilteres(marcacoes_assessoria)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postMarcacoesAssessoria = async function(dados, req) {
  try {

      const resultTipoReg = await database("marcacoes_assessoria").where({
        data_pclienteId: dados.data_pclienteId,
        horario_pclienteId: dados.horario_pclienteId,
        email: dados.email
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Registro já cadastrado!`)
        const rs = response("erro", 409, "Registro já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("marcacoes_assessoria").insert(dados);
      logger("SERVIDOR:Clientes").info(`MarcacoesAssessoria cadastrado com sucesso`)
      const rs = response("sucesso", 201, "MarcacoesAssessoria cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchMarcacoesAssessoria = async function(id_marcacoes_assessoria, dados, req) {
  try {

      const result = await database("marcacoes_assessoria")
      .where({id_marcacoes_assessoria});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("MarcacoesAssessoria não encontrados")
        const rs = response("erro", 403, "MarcacoesAssessoria não encontrados");
        return rs

      }

      await database("marcacoes_assessoria")
        .where({ id_marcacoes_assessoria })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_marcacoes_assessoria, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteMarcacoesAssessoria = async function(id_marcacoes_assessoria, req) {
  try {

      const dados = await database("marcacoes_assessoria").where({ id_marcacoes_assessoria })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("MarcacoesAssessoria não encontrados")
        const rs = response("erro", 403, "MarcacoesAssessoria não encontrados");
        return rs

      }

      await database("marcacoes_assessoria").where({ id_marcacoes_assessoria }).del();

      logger("SERVIDOR:loginClientes").info("MarcacoesAssessoria excluido feita com sucesso") 
      const rs = response("sucesso", 202, "MarcacoesAssessoria excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_marcacoes_assessoria, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
