const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const {pedidoCotacaoFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getMovimentosFinanceiro = async function(pagina, limite, total_registros, tipoMovimento, descricao, valor, dataMovimento, referenciaTipo, observacoes, req) {
     
    try{

        logger("SERVIDOR:getMovimentosFinanceiro").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("cliente","cliente.clienteId","=","movimento_financeiro.clienteIdMov")
        .join("empresa","empresa.empresaId","=","movimento_financeiro.empresaIdMov")
        .whereLike("tipoMovimento",`%${tipoMovimento}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("valor",`%${valor}%`)
        .whereLike("observacoes",`%${observacoes}%`)
        .whereLike("referenciaTipo",`%${referenciaTipo}%`)
        .whereLike("dataMovimento",`%${dataMovimento}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')

        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        logger("SERVIDOR:getMovimentosFinanceiro").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("cliente","cliente.clienteId","=","movimento_financeiro.clienteIdMov")
        .join("empresa","empresa.empresaId","=","movimento_financeiro.empresaIdMov")
        .whereLike("tipoMovimento",`%${tipoMovimento}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("valor",`%${valor}%`)
        .whereLike("observacoes",`%${observacoes}%`)
        .whereLike("referenciaTipo",`%${referenciaTipo}%`)
        .whereLike("dataMovimento",`%${dataMovimento}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc')
        
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.tipoMovimento = tipoMovimento
        registros.descricao = descricao
        registros.valor = valor
        registros.observacoes = observacoes
        registros.referenciaTipo = referenciaTipo
        registros.dataMovimento = dataMovimento

        delete registros.count

        logger("SERVIDOR:getMovimentosFinanceiro").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs

    
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiro").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}


module.exports.getMovimentosFinanceiroId = async function(movimentoFinanceiroId) {
     
     try{

        logger("SERVIDOR:getMovimentosFinanceiroId").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .where({movimentoFinanceiroId})
        .orderBy('movimentoFinanceiroId','desc')
        
        const [filtered] = pedidoCotacaoFilteres(movimento_financeiro)

        logger("SERVIDOR:getMovimentosFinanceiroId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered || {});            
        return rs      
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getMovimentosFinanceiroclienteId = async function(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getMovimentosFinanceiroclienteId").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')
      
        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        logger("SERVIDOR:getMovimentosFinanceiroclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getMovimentosFinanceiroclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getMovimentosFinanceiroEntidadeclienteId = async function(empresaId, clienteId, pagina, limite, total_registros, tipoMovimento, descricao, valor, dataMovimento, referenciaTipo, observacoes, req) {
     
     try{

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("cliente","cliente.clienteId","=","movimento_financeiro.clienteIdMov")
        .join("empresa","empresa.empresaId","=","movimento_financeiro.empresaIdMov")
        .whereLike("tipoMovimento",`%${tipoMovimento}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("valor",`%${valor}%`)
        .whereLike("observacoesFinanceiros",`%${observacoes}%`)
        .whereLike("referenciaTipo",`%${referenciaTipo}%`)
        .whereLike("dataMovimento",`%${dataMovimento}%`)
        .where({empresaIdMov: empresaId})
        .andWhere({clienteIdMov: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')
      
        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("cliente","cliente.clienteId","=","movimento_financeiro.clienteIdMov")
        .join("empresa","empresa.empresaId","=","movimento_financeiro.empresaIdMov")
        .whereLike("tipoMovimento",`%${tipoMovimento}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("valor",`%${valor}%`)
        .whereLike("observacoesFinanceiros",`%${observacoes}%`)
        .whereLike("referenciaTipo",`%${referenciaTipo}%`)
        .whereLike("dataMovimento",`%${dataMovimento}%`)
        .where({empresaIdMov: empresaId})
        .andWhere({clienteIdMov: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.tipoMovimento = tipoMovimento
        registros.descricao = descricao
        registros.valor = valor
        registros.observacoes = observacoes
        registros.referenciaTipo = referenciaTipo
        registros.dataMovimento = dataMovimento

        delete registros.count

        logger("SERVIDOR:getMovimentosFinanceiro").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getMovimentosFinanceiroEntidadeGrupoAfiliados = async function(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeGrupoAfiliados").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getMovimentosFinanceiroEntidadeGrupoAfiliados").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        const movimento_financeiro = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')

        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc')
      
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeGrupoAfiliados").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroEntidadeGrupoAfiliados").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getMovimentosFinanceiroEntidade = async function(empresaId, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req) {
     
     try{

        logger("SERVIDOR:getMovimentosFinanceiroEntidade").debug("Á carregar dados de configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getMovimentosFinanceiroEntidade").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getMovimentosFinanceiroEntidade").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora_transacao}%`)
        .whereLike("data_movimento",`%${data_transacao}%`)
        .where({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')    
      
        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        logger("SERVIDOR:getMovimentosFinanceiroEntidade").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora_transacao}%`)
        .whereLike("data_movimento",`%${data_transacao}%`)
        .where({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc')
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora_transacao = hora_transacao
        registros.data_transacao = data_transacao

        delete registros.count

        logger("SERVIDOR:getMovimentosFinanceiroEntidade").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroEntidade").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getMovimentosFinanceiroPeriodo = async function(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getMovimentosFinanceiroPeriodo").debug("Á carregar dados")
      const movimento_financeiro = await database('movimento_financeiro')
      .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('movimentoFinanceiroId','desc')  
              
      const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

      logger("SERVIDOR:getMovimentosFinanceiroPeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('movimento_financeiro')
      .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('movimentoFinanceiroId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getMovimentosFinanceiroPeriodo").info("Respondeu a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getMovimentosFinanceiroPeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getMovimentosFinanceiroEntidadePeriodo = async function(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").debug("Á carregar dados da configuração")
      const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

      if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
        logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").info("Serviço de pagamento por sector inactivo")
        const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
        return rs
      }

      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").debug("Á carregar dados")
      const movimento_financeiro = await database('movimento_financeiro')
      .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('movimentoFinanceiroId','desc')  
              
      const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('movimento_financeiro')
      .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('movimentoFinanceiroId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = empresaId
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getMovimentosFinanceiroEntidadeDias = async function(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").debug("Á carregar dados da configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')          
        
        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora
  
        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getMovimentosFinanceiroDias = async function(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{
      
        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").debug("Á carregar dados")
        const movimento_financeiro = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .limit(total_registros || pagination.total_limite)
        .orderBy('movimentoFinanceiroId','desc')          
        
        const {registros} = paginationRecords(movimento_financeiro, pagina, limite)

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('movimento_financeiro')
        .join("clienteIds","clienteIds.num_clienteId","=","movimento_financeiro.clienteIdMov_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('movimentoFinanceiroId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}
