const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const {pedidoCotacaoFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getPedidoCotacao = async function(pagina, limite, total_registros, numero_cotacao, statusPedido, descricaoPedido, quantidade, valorTotal, dataCriacao, req) {
     
    try{

        logger("SERVIDOR:getPedidoCotacao").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("cliente","cliente.clienteId","=","pedidocotacao.clienteIdPedido")
        .join("produto","produto.produtoId","=","pedidocotacao.produtoID")
        .whereLike("numero_cotacao",`%${numero_cotacao}%`)
        .whereLike("descricaoPedido",`%${descricaoPedido}%`)
        .whereLike("quantidade",`%${quantidade}%`)
        .whereLike("valorTotal",`%${valorTotal}%`)
        .whereLike("statusPedido",`%${statusPedido}%`)
        .whereLike("dataCriacao",`%${dataCriacao}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')

        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        logger("SERVIDOR:getPedidoCotacao").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("cliente","cliente.clienteId","=","pedidocotacao.clienteIdPedido")  
        .join("produto","produto.produtoId","=","pedidocotacao.produtoID")
        .whereLike("numero_cotacao",`%${numero_cotacao}%`)
        .whereLike("descricaoPedido",`%${descricaoPedido}%`)
        .whereLike("quantidade",`%${quantidade}%`)
        .whereLike("valorTotal",`%${valorTotal}%`)
        .whereLike("statusPedido",`%${statusPedido}%`)
        .whereLike("dataCriacao",`%${dataCriacao}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc')
        
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.numero_cotacao = numero_cotacao
        registros.descricaoPedido = descricaoPedido
        registros.quantidade = quantidade
        registros.valorTotal = valorTotal
        registros.statusPedido = statusPedido
        registros.statusPedido = statusPedido
        registros.dataCriacao = dataCriacao

        delete registros.count

        logger("SERVIDOR:getPedidoCotacao").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs

    
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacao").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}


module.exports.getPedidoCotacaoId = async function(pedidoCotacaoId) {
     
     try{

        logger("SERVIDOR:getPedidoCotacaoId").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .where({pedidoCotacaoId})
        .orderBy('pedidoCotacaoId','desc')
        
        const [filtered] = pedidoCotacaoFilteres(pedidocotacao)

        logger("SERVIDOR:getPedidoCotacaoId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered || {});            
        return rs      
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPedidoCotacaoclienteId = async function(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getPedidoCotacaoclienteId").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')
      
        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        logger("SERVIDOR:getPedidoCotacaoclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getPedidoCotacaoclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPedidoCotacaoEntidadeclienteId = async function(empresaId, clienteId, pagina, limite, total_registros, numero_cotacao, statusPedido, descricaoPedido, quantidade, valorTotal, dataCriacao, req) {
     
     try{

        logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: clienteId})        

        if((verifivarPagamentoTempoReal?.servico_principal == "false")){
          logger("SERVIDOR:loginClientes").warn("Serviço de gestão inactivo")
          const rs = response("erro", 423, "Serviço de gestão inactivo");
          return rs     
        }

        logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("cliente","cliente.clienteId","=","pedidocotacao.clienteIdPedido")
        .join("produto","produto.produtoId","=","pedidocotacao.produtoID")
        .whereLike("numero_cotacao",`%${numero_cotacao}%`)
        .whereLike("descricaoPedido",`%${descricaoPedido}%`)
        .whereLike("quantidade",`%${quantidade}%`)
        .whereLike("valorTotal",`%${valorTotal}%`)
        .whereLike("statusPedido",`%${statusPedido}%`)
        .whereLike("dataCriacao",`%${dataCriacao}%`)
        .where({empresaDona: empresaId})
        .andWhere({clienteIdPedido: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')
      
        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("cliente","cliente.clienteId","=","pedidocotacao.clienteIdPedido")
        .join("produto","produto.produtoId","=","pedidocotacao.produtoID")
        .whereLike("numero_cotacao",`%${numero_cotacao}%`)
        .whereLike("descricaoPedido",`%${descricaoPedido}%`)
        .whereLike("quantidade",`%${quantidade}%`)
        .whereLike("valorTotal",`%${valorTotal}%`)
        .whereLike("statusPedido",`%${statusPedido}%`)
        .whereLike("dataCriacao",`%${dataCriacao}%`)
        .where({empresaDona: empresaId}) 
        .andWhere({clienteIdPedido: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.numero_cotacao = numero_cotacao
        registros.descricaoPedido = descricaoPedido
        registros.quantidade = quantidade
        registros.valorTotal = valorTotal
        registros.statusPedido = statusPedido
        registros.statusPedido = statusPedido
        registros.dataCriacao = dataCriacao

        delete registros.count

        logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPedidoCotacaoEntidadeGrupoAfiliados = async function(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getPedidoCotacaoEntidadeGrupoAfiliados").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPedidoCotacaoEntidadeGrupoAfiliados").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        const pedidocotacao = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')

        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc')
      
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getPedidoCotacaoEntidadeGrupoAfiliados").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoEntidadeGrupoAfiliados").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPedidoCotacaoEntidade = async function(empresaId, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req) {
     
     try{

        logger("SERVIDOR:getPedidoCotacaoEntidade").debug("Á carregar dados de configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPedidoCotacaoEntidade").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getPedidoCotacaoEntidade").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora_transacao}%`)
        .whereLike("data_movimento",`%${data_transacao}%`)
        .where({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')    
      
        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        logger("SERVIDOR:getPedidoCotacaoEntidade").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora_transacao}%`)
        .whereLike("data_movimento",`%${data_transacao}%`)
        .where({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc')
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora_transacao = hora_transacao
        registros.data_transacao = data_transacao

        delete registros.count

        logger("SERVIDOR:getPedidoCotacaoEntidade").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoEntidade").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPedidoCotacaoPeriodo = async function(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getPedidoCotacaoPeriodo").debug("Á carregar dados")
      const pedidocotacao = await database('pedidocotacao')
      .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('pedidoCotacaoId','desc')  
              
      const {registros} = paginationRecords(pedidocotacao, pagina, limite)

      logger("SERVIDOR:getPedidoCotacaoPeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('pedidocotacao')
      .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('pedidoCotacaoId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getPedidoCotacaoPeriodo").info("Respondeu a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPedidoCotacaoPeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getPedidoCotacaoEntidadePeriodo = async function(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").debug("Á carregar dados da configuração")
      const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

      if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
        logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").info("Serviço de pagamento por sector inactivo")
        const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
        return rs
      }

      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").debug("Á carregar dados")
      const pedidocotacao = await database('pedidocotacao')
      .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('pedidoCotacaoId','desc')  
              
      const {registros} = paginationRecords(pedidocotacao, pagina, limite)

      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('pedidocotacao')
      .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('pedidoCotacaoId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = empresaId
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getPedidoCotacaoEntidadeDias = async function(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").debug("Á carregar dados da configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getPedidoCotacaoEntidadeDias").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')          
        
        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora
  
        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getPedidoCotacaoDias = async function(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{
      
        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").debug("Á carregar dados")
        const pedidocotacao = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .limit(total_registros || pagination.total_limite)
        .orderBy('pedidoCotacaoId','desc')          
        
        const {registros} = paginationRecords(pedidocotacao, pagina, limite)

        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('pedidocotacao')
        .join("clienteIds","clienteIds.num_clienteId","=","pedidocotacao.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('pedidoCotacaoId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        logger("SERVIDOR:getPedidoCotacaoEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.postPedidoCotacao = async function(dados, req) {
  try {

      const resultCliente = await database("cliente")
      .where({clienteId: dados.clienteIdPedido})
      .andWhere({empresaId: dados.empresaID});

      if (resultCliente.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "Seu usuario não encontrado");
        return rs

      }

      const resultProduto = await database("produto")
      .where({produtoId: dados.produtoID})
      .andWhere({empresaDona: dados.empresaID})
      .andWhere({ativo: "1"});

      if (resultProduto.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "Produto não encontrado ou foi desactivado");
        return rs

      }

      const numero_cotacao = "COT-" + "2025" + Math.random().toString().replace(".","").substr(0,5)
      const valorTotal = resultProduto[0].preco * Number(dados.quantidade)

      logger("SERVIDOR:loginClientes").debug("Registrando")
      await database("pedidocotacao").insert({ ...dados, numero_cotacao, valorTotal });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 201, "Pedido feito com sucesso", "json",{
        info:{
          ...dados,
          numero_cotacao,
          valorTotal
        }
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.patchPedidoCotacao = async function(pedidoCotacaoId, dados, req) {
  try {

      const result = await database("pedidocotacao")
      .where({pedidoCotacaoId});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "pedidoCotacaoId não encontrado");
        return rs

      }


      if (result[0].statusPedido != "Pendente") {

        logger("SERVIDOR:loginClientes").info("Registro já não pode ser actualizado")
        const rs = response("erro", 409, "Registro já não pode ser actualizado");
        return rs

      }

      await database("pedidocotacao")
        .where({ pedidoCotacaoId })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {pedidoCotacaoId, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deletePedidoCotacaoDias = async function(pedidoCotacaoId, req) {
  try {

      const dados = await database("pedidocotacao").where({ pedidoCotacaoId })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "Registro não encontrado");
        return rs

      }

      if (dados[0].statusPedido != "Pendente") {

        logger("SERVIDOR:loginClientes").info("Registro não pode ser deletado")
        const rs = response("erro", 409, "Registro não pode ser deletado");
        return rs

      }

      await database("pedidocotacao").where({ pedidoCotacaoId }).del();

      logger("SERVIDOR:loginClientes").info("Registro excluido feita com sucesso") 
      const rs = response("sucesso", 202, "Registro excluido feita com sucessoo")

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};