const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getSolicitacoesAtendimento = async function(pagina, limite, total_registros, nome, email, telefone, necessidade, status, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const solicitacoes_atendimento = await database("solicitacoes_atendimento")
      .whereLike("nome",`%${nome}%`)
      .whereLike("necessidade",`%${necessidade}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_envio",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_solicitacoes_atendimento", "DESC");

      const {registros} = paginationRecords(solicitacoes_atendimento, pagina, limite)

      const solicitacoes_atendimentoLimite = await database("solicitacoes_atendimento")
      .whereLike("nome",`%${nome}%`)
      .whereLike("necessidade",`%${necessidade}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_envio",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_solicitacoes_atendimento", "DESC");

      const filtered = usuariosFilteres(solicitacoes_atendimentoLimite)
      
      registros.total_apresentados = solicitacoes_atendimentoLimite.length
      registros.nome = nome
      registros.email = email
      registros.necessidade = necessidade
      registros.status = status
      registros.telefone = telefone
      registros.criacao = data_criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getSolicitacoesAtendimentoId = async function(id_solicitacoes_atendimento) {
  try {

      const solicitacoes_atendimento = await database("solicitacoes_atendimento")
      .where({ id_solicitacoes_atendimento })
      .orderBy("id_solicitacoes_atendimento", "DESC");

      const [filtered] = usuariosFilteres(solicitacoes_atendimento)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postSolicitacoesAtendimento = async function(dados, req) {
  try {

      const resultTipoReg = await database("solicitacoes_atendimento").where({
        email: dados.email,
        necessidade: dados.necessidade
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Registro já cadastrado!`)
        const rs = response("erro", 409, "Registro já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("solicitacoes_atendimento").insert(dados);
      logger("SERVIDOR:Clientes").info(`SolicitacoesAtendimento cadastrado com sucesso`)
      const rs = response("sucesso", 201, "SolicitacoesAtendimento cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchSolicitacoesAtendimento = async function(id_solicitacoes_atendimento, dados, req) {
  try {

      const result = await database("solicitacoes_atendimento")
      .where({id_solicitacoes_atendimento});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("SolicitacoesAtendimento não encontrados")
        const rs = response("erro", 403, "SolicitacoesAtendimento não encontrados");
        return rs

      }

      await database("solicitacoes_atendimento")
        .where({ id_solicitacoes_atendimento })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_solicitacoes_atendimento, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteSolicitacoesAtendimento = async function(id_solicitacoes_atendimento, req) {
  try {

      const dados = await database("solicitacoes_atendimento").where({ id_solicitacoes_atendimento })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("SolicitacoesAtendimento não encontrados")
        const rs = response("erro", 403, "SolicitacoesAtendimento não encontrados");
        return rs

      }

      await database("solicitacoes_atendimento").where({ id_solicitacoes_atendimento }).del();

      logger("SERVIDOR:loginClientes").info("SolicitacoesAtendimento excluido feita com sucesso") 
      const rs = response("sucesso", 202, "SolicitacoesAtendimento excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_solicitacoes_atendimento, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
