const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getTestemunhos = async function(pagina, limite, total_registros, nome, cargo, email, empresa, testemunho, status, criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const testemunhos = await database("testemunhos")
      .whereLike("nome",`%${nome}%`)
      .whereLike("cargo",`%${cargo}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("empresa",`%${empresa}%`)
      .whereLike("testemunho",`%${testemunho}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_criacao",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_testemunhos", "DESC");

      const {registros} = paginationRecords(testemunhos, pagina, limite)

      const testemunhosLimite = await database("testemunhos")
      .whereLike("nome",`%${nome}%`)
      .whereLike("cargo",`%${cargo}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("empresa",`%${empresa}%`)
      .whereLike("testemunho",`%${testemunho}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_criacao",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_testemunhos", "DESC");

      const filtered = usuariosFilteres(testemunhosLimite)
      
      registros.total_apresentados = testemunhosLimite.length
      registros.nome = nome
      registros.email = email
      registros.cargo = cargo
      registros.status = status
      registros.testemunho = testemunho
      registros.empresa = empresa
      registros.criacao = criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getTestemunhosId = async function(id_testemunhos) {
  try {

      const testemunhos = await database("testemunhos")
      .where({ id_testemunhos })
      .orderBy("id_testemunhos", "DESC");

      const [filtered] = usuariosFilteres(testemunhos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postTestemunhos = async function(dados, req) {
  try {

      const resultTipoReg = await database("testemunhos").where({
        email: dados.email
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Email já cadastrado!`)
        const rs = response("erro", 409, "Email já cadastrado!");
        return rs
      }

      const resultTelefone = await database("testemunhos").where({
        empresa: dados.empresa
      });

      if (resultTelefone.length > 0){
        logger("SERVIDOR:postClientes").info(`Telefone já cadastrado!`)
        const rs = response("erro", 409, "Telefone já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("testemunhos").insert(dados);
      logger("SERVIDOR:Clientes").info(`Testemunhos cadastrado com sucesso`)
      const rs = response("sucesso", 201, "Testemunhos cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchTestemunhos = async function(id_testemunhos, dados, req) {
  try {

      const result = await database("testemunhos")
      .where({id_testemunhos});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("Testemunhos não encontrados")
        const rs = response("erro", 403, "Testemunhos não encontrados");
        return rs

      }

      await database("testemunhos")
        .where({ id_testemunhos })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_testemunhos, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteTestemunhos = async function(id_testemunhos, req) {
  try {

      const dados = await database("testemunhos").where({ id_testemunhos })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("Testemunhos não encontrados")
        const rs = response("erro", 403, "Testemunhos não encontrados");
        return rs

      }

      await database("testemunhos").where({ id_testemunhos }).del();

      logger("SERVIDOR:loginClientes").info("Testemunhos excluido feita com sucesso") 
      const rs = response("sucesso", 202, "Testemunhos excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_testemunhos, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
