const express = require('express');
const router = express.Router();
const controller = require('../controllers/configuracoes'); 


/* GET configurações listing. */

router.get('/', controller.getConfiguracoes); 

router.get('/:entidade', controller.getConfiguracoesEntidade);

/* PATCH configurações listing. */

router.patch('/webhook/:entidade', controller.configurarWebhook)

router.patch('/sms/:entidade', controller.configurarSMS)

router.patch('/email/:entidade', controller.configurarEMAIL)

router.patch('/permissao/ips/:entidade', controller.configurarIPS)

router.patch('/realtime/:entidade', controller.configurarPagamentoRealTime)

router.patch('/area-doc/:entidade', controller.configurarDefinicoesPaginasDocs)

router.patch('/area-tecnica/:entidade', controller.configurarDefinicoesPaginasConfiguracaoTecnica)

router.patch('/coluna-prt-pagamentos/:entidade', controller.configurarDefinicoesPaginasConfiguracaoPRT)

router.patch('/coluna-mft-pagamentos/:entidade', controller.configurarDefinicoesPaginasConfiguracaoMFT)

router.patch('/coluna-conciliacao-pagamentos/:entidade', controller.configurarDefinicoesPaginasConfiguracaoConcliacao)

router.patch('/pagamento-gpo/:entidade', controller.configurarServicoGPO)

router.patch('/pagamento-por-sector/:entidade', controller.configurarServicoPagamentoPorSector)

 

module.exports = router;  