const express = require('express');
const router = express.Router();
const controller = require('../controllers/empresas'); 


/* GET clientes listing. */
router.get('/', controller.getEmpresas); 

router.get('/:empresaId', controller.getEmpresasId);

router.get('/entidade/:empresaId', controller.getEmpresasEntidade);

router.get('/hash/:hash', controller.getEmpresasHash); 

router.get('/email/:email', controller.getEmpresasEmail);

/* POST clientes listing. */

router.post('/', controller.postEmpresas);

router.post('/login', controller.loginEmpresas); 

router.post('/logout', controller.logoutEmpresas);

router.post('/comunicar-por-email', controller.comunicarEmail);

router.post('/activar-por-codigo', controller.activarPorCodigo); 

router.post('/codigo-seguranca/pedir', controller.recuperarSenha);

router.post('/codigo-seguranca/autenticar', controller.redifinirSenha);

/* PATCH clientes listing. */

router.patch('/:empresaId', controller.patchEmpresas)

router.patch('/:entidade/redifinir-senha', controller.patchEmpresasRedifinirSenha);

router.patch('/:entidade/trocar-senha-padrao', controller.patchEmpresasTrocarSenhaPadrao);

router.patch('/:entidade/verificar-senha-actual', controller.patchEmpresasVerificarSenhaActual);

router.patch('/:entidade/alterar-senha', controller.patchEmpresasAlterarSenha);

router.patch('/mudar/foto/:entidade', controller.mudarFotoEmpresas);

router.post('/mudar/arquivo-contrato/:entidade', controller.mudarArquivoContratoEmpresas);

router.patch('/repor-clientes/:empresaId', controller.configurarReporEmpresas)

router.patch('/bloquear/:empresaId', controller.patchEmpresasBloquear)

router.patch('/desbloquear/:empresaId', controller.patchEmpresasDesbloquear)

/* DELETE clientes listing. */

router.delete('/:empresaId', controller.deleteEmpresas)


module.exports = router;  