const express = require('express');
const router = express.Router();
const controller = require('../controllers/movimentos_financeiro');

/* GET MovimentosFinanceiro listing. */
router.get('/', controller.getMovimentosFinanceiro);

router.get('/:movimentoFinanceiroId', controller.getMovimentosFinanceiroId);

router.get('/clienteId/:clienteId', controller.getMovimentosFinanceiroclienteId);

router.get('/periodo/:periodo', controller.getMovimentosFinanceiroPeriodo);

router.get('/entidade/:empresaId', controller.getMovimentosFinanceiroEntidade);

router.get('/entidade/:empresaId/periodo/:periodo', controller.getMovimentosFinanceiroEntidadePeriodo);

router.get('/entidade/:empresaId/clienteId/:clienteId', controller.getMovimentosFinanceiroEntidadeclienteId);

router.get('/entidade/:empresaId/grupo/:grupo_identificacao', controller.getMovimentosFinanceiroEntidadeGrupoAfiliados);

router.get('/entidade/:empresaId/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getMovimentosFinanceiroEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getMovimentosFinanceiroDias);

module.exports = router;