const express = require('express');
const router = express.Router();
const controller = require('../controllers/pedidos');

/* GET PedidoCotacao listing. */
router.get('/', controller.getPedidoCotacao);

router.get('/:pedidoCotacaoId', controller.getPedidoCotacaoId);

router.get('/clienteId/:clienteId', controller.getPedidoCotacaoclienteId);

router.get('/periodo/:periodo', controller.getPedidoCotacaoPeriodo);

router.get('/entidade/:empresaId', controller.getPedidoCotacaoEntidade);

router.get('/entidade/:empresaId/periodo/:periodo', controller.getPedidoCotacaoEntidadePeriodo);

router.get('/entidade/:empresaId/clienteId/:clienteId', controller.getPedidoCotacaoEntidadeclienteId);

router.get('/entidade/:empresaId/grupo/:grupo_identificacao', controller.getPedidoCotacaoEntidadeGrupoAfiliados);

router.get('/entidade/:empresaId/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPedidoCotacaoEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPedidoCotacaoDias);

// POST
router.post('/', controller.postPedidoCotacao);

// PATCH
router.patch('/:pedidoCotacaoId', controller.patchPedidoCotacao);

// DETELE
router.delete('/:pedidoCotacaoId', controller.deletePedidoCotacaoDias)

module.exports = router;