const models = require('../models/conteudo_sobre_nos_blocos')
const bcrypt = require('bcryptjs');
const yup = require('yup')
const logger = require('../services/loggerService'); 
const response = require("../constants/response");
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 
const StrengthSchecker = require('../helpers/StrengthSchecker');

module.exports.getConteudoSobreNosBloco = async function(req, res, next) { 
  try {  
      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {pagina, limite, total_registros, tipo = '', titulo = '', conteudo = '', status = '', ordem = ''} = req.query
      const results = await models.getConteudoSobreNosBloco(pagina, limite, total_registros, tipo, titulo, conteudo, status, ordem)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getConteudoSobreNosBlocoId = async function(req, res, next) {
  try {  

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {id_conteudo_sobre_nos_blocos} = req.params
      const results = await models.getConteudoSobreNosBlocoId(id_conteudo_sobre_nos_blocos)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.postConteudoSobreNosBloco = async function(req, res, next) {
  try {

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const dados = req.body
      const headers = req.headers
      const phoneRegExp = /^((\\+[1-9]{1,4}[ \\-]*)|(\\([0-9]{2,3}\\)[ \\-]*)|([0-9]{2,4})[ \\-]*)*?[0-9]{3,4}?[ \\-]*[0-9]{3,4}?$/
      
      const schemaConteudoSobreNosBloco = yup.object().shape({
        tipo: yup.mixed().oneOf(['missao','visao','valores','outro']).default('missao'),
        titulo: yup.string().required(),
        status: yup.mixed().oneOf(['ativo', 'inativo']).default('ativo'), 
        ordem: yup.number().required(),
        conteudo: yup.string().required(),
      }) 

      const schemaConteudoSobreNosBlocoHeader = yup.object().shape({
        gerador: yup.number().required(),
      }) 

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaConteudoSobreNosBloco.validate(dados)
      const validarHeaders = await schemaConteudoSobreNosBlocoHeader.validate(headers)
      
      const result = await models.postConteudoSobreNosBloco({...validar}, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)          
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}


module.exports.patchConteudoSobreNosBloco = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_conteudo_sobre_nos_blocos} = req.params
        const dados = req.body
        const phoneRegExp = /^((\\+[1-9]{1,4}[ \\-]*)|(\\([0-9]{2,3}\\)[ \\-]*)|([0-9]{2,4})[ \\-]*)*?[0-9]{3,4}?[ \\-]*[0-9]{3,4}?$/
        
        const schemaConteudoSobreNosBloco = yup.object().shape({
          tipo: yup.mixed().oneOf(['missao','visao','valores','outro']).default('missao'),
          titulo: yup.string(),
          status: yup.mixed().oneOf(['ativo', 'inativo']).default('ativo'), 
          ordem: yup.number(),
          conteudo: yup.string(),
        }) 

        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaConteudoSobreNosBloco.validate(dados)
        
        const result = await models.patchConteudoSobreNosBloco(id_conteudo_sobre_nos_blocos, validar, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }

module.exports.deleteConteudoSobreNosBloco = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_conteudo_sobre_nos_blocos} = req.params
        const result = await models.deleteConteudoSobreNosBloco(id_conteudo_sobre_nos_blocos, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
}