const models = require('../models/cursos')
const yup = require('yup')
const logger = require('../services/loggerService'); 
const response = require("../constants/response");
const { parse, isDate } = require("date-fns");
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

function parseDateString(value, originalValue) {
  const parsedDate = isDate(new Date(originalValue))
    ? new Date(originalValue)
    : parse(originalValue, "yyyy-MM-dd", new Date());

  return parsedDate;
}

module.exports.getCursos = async function(req, res, next) { 
  try {  
      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {pagina, limite, total_registros, titulo = '', descricao_curta = '', descricao_longa = '', preco = '', duracao = '', data_inicio = '', data_fim = '', destaque = '', status = '', data_criacao = ''} = req.query
      const results = await models.getCursos(pagina, limite, total_registros, titulo, descricao_curta, descricao_longa, preco, duracao, data_inicio, data_fim, destaque, status, data_criacao)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getCursosId = async function(req, res, next) {
  try {  

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const {id_cursos} = req.params
      const results = await models.getCursosId(id_cursos)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.postCursos = async function(req, res, next) {
  try {

      logger("SERVIDOR:").info(`Buscar os afiliados`)
      const dados = req.body
      const headers = req.headers

      const schemaCursos = yup.object().shape({
        titulo: yup.string().required(),
        descricao_curta: yup.string().required(),
        descricao_longa: yup.string().required(),
        imagem_destacada: yup.string().required(),
        duracao: yup.string().required(),
        preco: yup.number().required(),
        status: yup.mixed().oneOf(['ativo', 'inativo']).default('ativo'), 
        destaque: yup.number().required(),
        ordem: yup.number().required(),
        data_inicio: yup.date().transform(parseDateString).required(),
        data_fim: yup.date().transform(parseDateString).required()
      }) 

      const schemaCursosHeader = yup.object().shape({
        gerador: yup.number().required(),
      }) 

      logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
      const validar = await schemaCursos.validate(dados)
      const validarHeaders = await schemaCursosHeader.validate(headers)
      
      const result = await models.postCursos({...validar, gerado_por: validarHeaders.gerador}, req)

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification
      
      res.status(result.statusCode).json(result)          
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, nt, wk})
      }

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}


module.exports.patchCursos = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_cursos} = req.params
        const dados = req.body
        
        const schemaCursos = yup.object().shape({
        titulo: yup.string(),
        descricao_curta: yup.string(),
        descricao_longa: yup.string(),
        imagem_destacada: yup.string(),
        duracao: yup.string(),
        preco: yup.number(),
        status: yup.mixed().oneOf(['ativo', 'inativo']).default('ativo'), 
        destaque: yup.number(),
        ordem: yup.number(),
        data_inicio: yup.date().transform(parseDateString),
        data_fim: yup.date().transform(parseDateString)
      })

        logger("SERVIDOR:postAfiliados").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaCursos.validate(dados)
        
        const result = await models.patchCursos(id_cursos, validar, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }

module.exports.deleteCursos = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {id_cursos} = req.params
        const result = await models.deleteCursos(id_cursos, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
    }
}