const models = require('../models/dashboard')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getDashboard = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getDashboard").info("Buscar os dados")
      
      const {pagina, limite, total_registros, codigoProduto = '', descricao = '', unidadeMedida = '', preco = '', categoria = '', ativo = '', dataProduto = ''} = req.query
      const results = await models.getDashboard(pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboard").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getDashboardId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardId").info("Buscar os dados")
      const {produtoId} = req.params
      const results = await models.getDashboardId(produtoId)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getDashboardclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardclienteId").info("Buscar os dados")
      const {empresaId, clienteId} = req.params
      const {ano} = req.query
      const results = await models.getDashboardclienteId(empresaId, clienteId, ano)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getDashboardEntidadeclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardEntidadeclienteId").info("Buscar os dados")
      const {empresaId, clienteId} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getDashboardEntidadeclienteId(empresaId, clienteId, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardEntidadeclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getDashboardEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardEntidadeGrupoAfiliados").info("Buscar os dados")
      const {empresaId, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getDashboardEntidadeGrupoAfiliados(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getDashboardEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardEntidade").info("Buscar os dados")
      const {empresaId} = req.params
      const {pagina, limite, total_registros} = req.query
      const results = await models.getDashboardEntidade(empresaId, ano = 2025, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getDashboardPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardEntidade").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getDashboardPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getDashboardEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {empresaId,periodo} = req.params
      const results = await models.getDashboardEntidadePeriodo(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getDashboardEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardEntidadeDias").info("Buscar os dados")
      const {empresaId, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getDashboardEntidadeDias(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
module.exports.getDashboardDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getDashboardDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getDashboardDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getDashboardDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}