const models = require('../models/movimentos_financeiro')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 

module.exports.getMovimentosFinanceiro = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getMovimentosFinanceiro").info("Buscar os dados")
      
      const {pagina, limite, total_registros, tipoMovimento = '', descricao = '', valor = '', dataMovimento = '', referenciaTipo = '', observacoes = ''} = req.query
      const results = await models.getMovimentosFinanceiro(pagina, limite, total_registros, tipoMovimento, descricao, valor, dataMovimento, referenciaTipo, observacoes, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiro").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getMovimentosFinanceiroId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroId").info("Buscar os dados")
      const {movimentoFinanceiroId} = req.params
      const results = await models.getMovimentosFinanceiroId(movimentoFinanceiroId)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getMovimentosFinanceiroclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroclienteId").info("Buscar os dados")
      const {clienteId} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getMovimentosFinanceiroclienteId(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getMovimentosFinanceiroEntidadeclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").info("Buscar os dados")
      const {empresaId, clienteId} = req.params
      const {pagina, limite, total_registros, tipoMovimento = '', descricao = '', valor = '', dataMovimento = '', referenciaTipo = '', observacoes = ''} = req.query
      const results = await models.getMovimentosFinanceiroEntidadeclienteId(empresaId, clienteId, pagina, limite, total_registros, tipoMovimento, descricao, valor, dataMovimento, referenciaTipo, observacoes, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroEntidadeclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getMovimentosFinanceiroEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroEntidadeGrupoAfiliados").info("Buscar os dados")
      const {empresaId, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getMovimentosFinanceiroEntidadeGrupoAfiliados(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getMovimentosFinanceiroEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroEntidade").info("Buscar os dados")
      const {empresaId} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora_transacao = '', data_transacao = ''} = req.query
      const results = await models.getMovimentosFinanceiroEntidade(empresaId, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getMovimentosFinanceiroPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroEntidade").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getMovimentosFinanceiroPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getMovimentosFinanceiroEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {empresaId,periodo} = req.params
      const results = await models.getMovimentosFinanceiroEntidadePeriodo(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getMovimentosFinanceiroEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").info("Buscar os dados")
      const {empresaId, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getMovimentosFinanceiroEntidadeDias(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
module.exports.getMovimentosFinanceiroDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getMovimentosFinanceiroDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getMovimentosFinanceiroDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getMovimentosFinanceiroDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}