const models = require('../models/pedidos')
const response = require("../constants/response");
const logger = require('../services/loggerService'); 
const yup = require('yup')
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

module.exports.getPedidoCotacao = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:getPedidoCotacao").info("Buscar os dados")
      
      const {pagina, limite, total_registros, numero_cotacao = '', statusPedido = '', descricaoPedido = '', quantidade = '', valorTotal = '', dataCriacao = ''} = req.query
      const results = await models.getPedidoCotacao(pagina, limite, total_registros, numero_cotacao, statusPedido, descricaoPedido, quantidade, valorTotal, dataCriacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacao").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPedidoCotacaoId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoId").info("Buscar os dados")
      const {pedidoCotacaoId} = req.params
      const results = await models.getPedidoCotacaoId(pedidoCotacaoId)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPedidoCotacaoclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoclienteId").info("Buscar os dados")
      const {clienteId} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPedidoCotacaoclienteId(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPedidoCotacaoEntidadeclienteId = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").info("Buscar os dados")
      const {empresaId, clienteId} = req.params
      const {pagina, limite, total_registros, numero_cotacao = '', statusPedido = '', descricaoPedido = '', quantidade = '', valorTotal = '', dataCriacao = ''} = req.query
      const results = await models.getPedidoCotacaoEntidadeclienteId(empresaId, clienteId, pagina, limite, total_registros, numero_cotacao, statusPedido, descricaoPedido, quantidade, valorTotal, dataCriacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoEntidadeclienteId").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}

module.exports.getPedidoCotacaoEntidadeGrupoAfiliados = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoEntidadeGrupoAfiliados").info("Buscar os dados")
      const {empresaId, grupo_identificacao} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPedidoCotacaoEntidadeGrupoAfiliados(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoEntidadeGrupoAfiliados").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPedidoCotacaoEntidade = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoEntidade").info("Buscar os dados")
      const {empresaId} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora_transacao = '', data_transacao = ''} = req.query
      const results = await models.getPedidoCotacaoEntidade(empresaId, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req)
      
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPedidoCotacaoPeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoEntidade").info("Buscar os dados")
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {periodo} = req.params
      const results = await models.getPedidoCotacaoPeriodo(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoEntidade").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPedidoCotacaoEntidadePeriodo = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").info("Buscar os dados")
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const {empresaId,periodo} = req.params
      const results = await models.getPedidoCotacaoEntidadePeriodo(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora)
      
      res.status(results.statusCode).json(results) 
         
  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoEntidadePeriodo").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getPedidoCotacaoEntidadeDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoEntidadeDias").info("Buscar os dados")
      const {empresaId, dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      const results = await models.getPedidoCotacaoEntidadeDias(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoEntidadeDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}
module.exports.getPedidoCotacaoDias = async function(req, res, next) {
  try {

      logger("SERVIDOR:getPedidoCotacaoDias").info("Buscar os dados")
      const {dia_inicio, dia_final} = req.params
      const {pagina, limite, total_registros, entidade = '', montante = '', tarifa = '', clienteId = '', periodo = '', log_transacao = '', terminal = '' , nib = '', hora = ''} = req.query
      
      const results = await models.getPedidoCotacaoDias(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora)

      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message);
      logger("SERVIDOR:getPedidoCotacaoDias").error(`Erro a buscar os dados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.postPedidoCotacao = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const dados = req.body

        const schemaPedidos = yup.object().shape({
          clienteIdPedido: yup.number().required(),
          empresaID: yup.number().required(),
          produtoID: yup.number().required(),
          // valorTotal: yup.number().required(),
          descricaoPedido: yup.string().required(),
          quantidade: yup.number().min(1).required()
        })

        logger("SERVIDOR:patchClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaPedidos.validate(dados)
        
        const result = await models.postPedidoCotacao(validar, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }


module.exports.patchPedidoCotacao = async function(req, res, next) {
    try {  

        logger("SERVIDOR:").info(`Buscar os afiliados`)
        const {pedidoCotacaoId} = req.params
        const dados = req.body

        const schemaPedidos = yup.object().shape({
          descricaoPedido: yup.string(),
          quantidade: yup.number().min(1)
        })

        logger("SERVIDOR:patchClientes").debug(`Á validar os dados ${JSON.stringify(dados)}`)
        const validar = await schemaPedidos.validate(dados)
        
        const result = await models.patchPedidoCotacao(pedidoCotacaoId, validar, req)

        var wk = result.webhook
        var lg = result.logs
        var nt = result.notification
        
        delete result.webhook
        delete result.logs
        delete result.notification
        
        res.status(result.statusCode).json(result)          
        if(result.status == "sucesso"){
          sendRequestOnMicroservices({lg, nt, wk})
        }

    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)
  
        if(error?.path){
          const rs = response("erro", 412, error.message);
          res.status(rs.statusCode).json(rs)        
        }else{  
          const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
          res.status(rs.statusCode).json(rs)
        }
    }
    
  }

module.exports.deletePedidoCotacaoDias = async function(req, res, next) {

  try {

      const {pedidoCotacaoId} = req.params
      const result = await models.deletePedidoCotacaoDias(pedidoCotacaoId, req)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification

      res.status(result.statusCode).json(result)
      
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, wk, nt})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}