const models = require('../models/relatorios')
const yup = require('yup')
const response = require("../constants/response");
const logger = require('../services/loggerService');
const path = require('path');
const axios = require('axios');
const fs = require('fs')
const json2xls = require('json2xls');
const https = require('https')
const FormData = require('form-data');
const sendRequestOnMicroservices = require("../helpers/sendRequestOnMicroservices"); 

require("dotenv").config({ path: path.join(__dirname, '.env') }); 

module.exports.getRelatorios = async function(req, res, next) {
  try {
  
      logger("SERVIDOR:Clientes").info("Buscar clientes")
      const {pagina, limite, total_registros, nome_empresa = '', email = '', entidade = ''} = req.query
      const results = await models.getRelatorios(pagina, limite, total_registros, nome_empresa, email, entidade)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
     
}

module.exports.getRelatoriosId = async function(req, res, next) {
  try {
    const {id_relatorio} = req.params
    const results = await models.getRelatoriosId(id_relatorio)
    res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs) 
  }
    
}

module.exports.getRelatoriosEntidade = async function(req, res, next) {
  try {
      const {entidade, clienteId} = req.params
      const {pagina, limite, total_registros} = req.query
      const results = await models.getRelatoriosEntidade(pagina, limite, total_registros, entidade, clienteId) 
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getRelatoriosEntidadeEmpresaTipo = async function(req, res, next) {
  try {
      const {entidade, clienteId, tipo} = req.params
      const {pagina, limite, total_registros} = req.query
      const results = await models.getRelatoriosEntidadeEmpresaTipo(pagina, limite, total_registros, entidade, clienteId, tipo) 
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}

module.exports.getRelatoriosEntidadeTipo = async function(req, res, next) {
  try {
      const {entidade, tipo} = req.params
      const {pagina, limite, total_registros} = req.query
      const results = await models.getRelatoriosEntidadeTipo(pagina, limite, total_registros, entidade, tipo)
      res.status(results.statusCode).json(results)

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
    
}


module.exports.postRelatorios = async function(req, res, next) {
  
  try {

      const dados = req.body

      const schemaRelatorios = yup.object().shape({
        empresa: yup.number().required(),
        cliente: yup.number().required(),
        tipo: yup.string().oneOf(['Cotacoes','Facturas','Movimentos']).required('Por favor seleccione entre Cotacoes, Facturas ou Movimentos'),
        campos: yup.object().required(),
      })
      
      const validar = await schemaRelatorios.validate(dados)
      const result = await models.postRelatorios(validar)
      
      
      if(result.status === "sucesso"){  

        if(result.mensagem.tipo == "Cotacoes"){
          var xls = json2xls(result.mensagem.cotacoes);  
            if(result.mensagem.cotacoes.length){
              if(!fs.existsSync(path.join(__dirname, "../reports")))  fs.mkdirSync(path.join(__dirname, "../reports"), { recursive: true });

                  fs.appendFileSync(path.join(__dirname, "../reports", result.mensagem.filename), xls, {
                    encoding: "binary"
                  });
            }
        }else if(result.mensagem.tipo == "Facturas"){
          if(result.mensagem.facturas.length){
              var xls = json2xls(result.mensagem.facturas);  
              if(!fs.existsSync(path.join(__dirname, "../reports")))  fs.mkdirSync(path.join(__dirname, "../reports"), { recursive: true });

                  fs.appendFileSync(path.join(__dirname, "../reports", result.mensagem.filename), xls, {
                    encoding: "binary"
                  });
              }
            
        }else if(result.mensagem.tipo == "Movimentos"){          
          
          var xls = json2xls(result.mensagem.movimentos);
          if(result.mensagem.movimentos.length){
            
              if(!fs.existsSync(path.join(__dirname, "../reports")))  fs.mkdirSync(path.join(__dirname, "../reports"), { recursive: true });

                  fs.appendFileSync(path.join(__dirname, "../reports", result.mensagem.filename), xls, {
                    encoding: "binary"
                  });
              }
            
        }

        /*try {
          const config = {
              maxBodyLength : Infinity,
              insecureHTTPParser: true,
              headers: {
                  "Content-Type": "multipart/form-data",
                  Authorization : 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJhcHAiOnsiZG9ubyI6IjNlMWVmOGYwODM2MDZmZTU5M2RiMTY3YTVlMjg3OWQzZTgzYTFlNGQxNTNlMzgzNjQ3M2E2MmZjYjRjN2UzZDU4MmY5NmE2YTFiNWYifX0.u9R7DsHAGBbunFFUiHtsvgUS0h6zxtjD_NPm3np4A50f_MKb0VDOY0mG0o_na3cTuEJzK_k7uiCleB8HFXARsg',
                  Auth : 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJhcHAiOnsiZG9ubyI6IjNlMWVmOGYwODM2MDZmZTU5M2RiMTY3YTVlMjg3OWQzZTgzYTFlNGQxNTNlMzgzNjQ3M2E2MmZjYjRjN2UzZDU4MmY5NmE2YTFiNWYifX0.u9R7DsHAGBbunFFUiHtsvgUS0h6zxtjD_NPm3np4A50f_MKb0VDOY0mG0o_na3cTuEJzK_k7uiCleB8HFXARsg'
                  },
              httpsAgent: new https.Agent({  
                  rejectUnauthorized: false,
                  keepAlive: true
              })
              }

              const instance = axios.create(config)

              const fileOrigin = path.join(__dirname, "../reports", result.mensagem.filename) 

              const fileStream1 = fs.createReadStream(fileOrigin)                     

              const form1 = new FormData();
              form1.append('arquivo', fileStream1);
              
              
              await instance.post(process.env.HOST_1,form1);
              
        } catch (error) {
            console.log(error.message)
        }*/

        
      }

      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification

      res.status(result.statusCode).json(result)
      
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, wk, nt})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:postClientes").error(`Erro ao cadastrar o cliente ${error.message}`)

      if(error?.path){
        const rs = response("erro", 412, error.message);
        res.status(rs.statusCode).json(rs)        
      }else{  
        const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
        res.status(rs.statusCode).json(rs)
      }
  }
    
}

module.exports.deleteRelatorios = async function(req, res, next) {

  try {

      const {id_relatorio} = req.params
      const result = await models.deleteRelatorios(id_relatorio, req)
      
      var wk = result.webhook
      var lg = result.logs
      var nt = result.notification
      
      delete result.webhook
      delete result.logs
      delete result.notification

      res.status(result.statusCode).json(result)
      
      if(result.status == "sucesso"){
        sendRequestOnMicroservices({lg, wk, nt})
      } 

  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getAfiliados").error(`Erro buscar afiliados ${error.message}`)
      const rs = response("erro", 400, `Algo aconteceu. Tente de novo, ${error.message}`);
      res.status(rs.statusCode).json(rs)
  }
  
}
