const database = require('../config/database')
const path = require("path");
const response = require("../constants/response");
const logger = require('../services/loggerService');
const paginationRecords = require("../helpers/paginationRecords");
const { configuracoesFilteres } = require('../helpers/filterResponseSQL');
require("dotenv").config({ path: path.resolve(path.join(__dirname,'../','.env')) });


module.exports.getConfiguracoes = async function(pagina, limite, nome_empresa, nif, email, entidade, responsavel) {
  try {
      
      logger("SERVIDOR:Configuracoes").debug("Selecionar da base de dados")

      const configuracoes = await database('clientes')
      .join('configuracoes',"configuracoes.clienteIdConf","=","clientes.empresaId")
      .whereLike("nome_empresa",`%${String(nome_empresa).toUpperCase()}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .whereLike("responsavel",`%${responsavel}%`)
      .orderBy('id_clientes','DESC')

      const {registros} = paginationRecords(configuracoes, pagina, limite)

      logger("Configuracoes").debug(`Buscar todos clientes no banco de dados com limite de ${registros.limite} na pagina ${registros.count} de registros`);
      const configuracoesLimite = await database('clientes')
      .join('configuracoes',"configuracoes.clienteIdConf","=","clientes.empresaId")
      .whereLike("nome_empresa",`%${String(nome_empresa).toUpperCase()}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .whereLike("responsavel",`%${responsavel}%`)
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('id_clientes','DESC')

      const filtered = configuracoesFilteres(configuracoesLimite)

      registros.total_apresentados = configuracoesLimite.length
      registros.nome_empresa = nome_empresa
      registros.nif = nif
      registros.email = email
      registros.entidade = entidade
      registros.responsavel = responsavel

      logger("SERVIDOR:Configuracoes").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered, "json", { registros });
      return rs


  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:Configuracoes").error(`Erro ao buscar clientes ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.getConfiguracoesEntidade = async function(entidade) {
  try {

      logger("SERVIDOR:getConfiguracoesEntidade").debug("Á buscar os dados")
      const configuracoes = await database('clientes')
      .join('configuracoes',"configuracoes.clienteIdConf","=","clientes.empresaId")
      .where({empresaId:entidade})
      .orderBy('id_clientes','DESC')  

      const [filtered] = configuracoesFilteres(configuracoes)
    
      logger("SERVIDOR:getConfiguracoesEntidade").info("Respondeu a solicitação")
      const rs = response("sucesso", 200, filtered || {}, "json");          
      return rs

  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:getConfiguracoesEntidade").error(`Erro ao buscar clientes por entidade ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarWebhook = async function(entidade, estado , req) { 
  try {

      logger("SERVIDOR:configurarWebhook").debug(`Selecionar o cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:patchConfiguracoesBloquear").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarWebhook").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf}).update({aceitar_webhook: estado})

      logger("SERVIDOR:configurarWebhook").info(estado === "true" ? "Integração de webhook activo" : "Integração de webhook desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Integração de webhook activo" : "Integração de webhook desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "WEBHOOKACTIVE" : "WEBHOOKDESACTIVE", tabela: "CONFIGURACOES", informacao: {pagamento_tempo_real: estado, entidade}, entidade}
      });
      return rs

  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarWebhook").error(`Erro ao configurar acesso ao webhook ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarSMS = async function(entidade, estado , req) {
  try {
      
      logger("SERVIDOR:configurarSMS").debug(`Selecionar o cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarSMS").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarSMS").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({servico_mensagens: estado})

      logger("SERVIDOR:configurarSMS").info(estado === "true" ? "Integração de SMS activo" : "Integração de SMS desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Integração de SMS activo" : "Integração de SMS desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "WEBHOOKACTIVE" : "WEBHOOKDESACTIVE", tabela: "CONFIGURACOES", informacao: {pagamento_tempo_real: estado, entidade}, entidade}
      });
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarSMS").error(`Erro ao configurar acesso a sms ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarEMAIL = async function(entidade, estado , req) {
  try {
      
      logger("SERVIDOR:configurarSMS").debug(`Selecionar o cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarSMS").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarSMS").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({servico_email: estado})

      logger("SERVIDOR:configurarSMS").info(estado === "true" ? "Integração de EMAIL activo" : "Integração de EMAIL desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Integração de EMAIL activo" : "Integração de EMAIL desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "WEBHOOKACTIVE" : "WEBHOOKDESACTIVE", tabela: "CONFIGURACOES", informacao: {pagamento_tempo_real: estado, entidade}, entidade}
      });
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarSMS").error(`Erro ao configurar acesso a emails ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarIPS = async function(entidade, ip_primario, ip_secundario , req) {
  try {
    logger("SERVIDOR:configurarIPS").debug(`Verficando o cliente`)
    const configuracoes = await database('clientes').where({empresaId: entidade});

    if(!configuracoes.length){
      logger("SERVIDOR:configurarIPS").info("Cliente não foi encontrado")
      const rs = response("erro", 409, "Cliente não foi encontrado");
      return rs    
    }

    logger("SERVIDOR:configurarIPS").debug(`Actualizar os ips`)
    await database('configuracoes').where({clienteIdConf: entidade}).update({ip_primario, ip_secundario})

    logger("SERVIDOR:configurarIPS").info(`IP(s), configuirados e aceites`)
    const rs = response("sucesso", 202, "IP(s), configuirados e aceites", "json", {
      logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "IPACCEPTS", tabela: "CONFIGURACOES", informacao: {ip_primario, ip_secundario, entidade: entidade}, entidade: entidade}
    });
    return rs
    
  } catch (erro) {
    console.log(erro)
    logger("SERVIDOR:configurarIPS").error(`Erro ao configurar ips ${erro.message}`)
    const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
    return rs
  }
    
}

module.exports.configurarPagamentoRealTime = async function(entidade, estado , req) {
  try {

      logger("SERVIDOR:configurarPagamentoRealTime").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarPagamentoRealTime").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarPagamentoRealTime").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({pagamento_tempo_real: estado})

      logger("SERVIDOR:configurarPagamentoRealTime").info(estado === "true" ? "Notificações de pagamento activo" : "Notificações de pagamento desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Notificações de pagamento activo" : "Notificações de pagamento desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "PAYMENTEREALTIMEACTIVE" : "PAYMENTEREALTIMEDESACTIVE", tabela: "CONFIGURACOES", informacao: {pagamento_tempo_real: estado, entidade: entidade}, entidade: entidade}
      });
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarPagamentoRealTime").error(`Erro ao configurar realTime ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarDefinicoesPaginasDocs = async function(entidade, estado , req) {
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasDocs").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId:entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarDefinicoesPaginasDocs").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarDefinicoesPaginasDocs").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({habilitar_area_docs: estado})

      logger("SERVIDOR:configurarPagamentoRealTime").info(estado === "true" ? "Aréa de documentações e manual activa" : "Aréa de documentações e manual activa desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Aréa de documentações e manual activa" : "Aréa de documentações e manual activa desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVEAREADOC" : "DESACTIVEAREADOC" , tabela: "CONFIGURACOES", informacao: {servico_gpo: estado, entidade}, entidade}
      });
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarDefinicoesPaginasDocs").error(`Erro ao configurar as paginas de documentação ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarDefinicoesPaginasConfiguracaoTecnica = async function(entidade, estado , req) {
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({habilitar_area_tecnica: estado})

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").info(estado === "true" ? "Aréa de integração e tecnica activo" : "Aréa de integração e tecnica desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Aréa de integração e tecnica activo" : "Aréa de integração e tecnica desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVEAREATECNIVA" : "DESACTIVEAREATECNIVA" , tabela: "CONFIGURACOES", informacao: {servico_gpo: estado, entidade}, entidade}
      });
      return rs
      
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoTecnica").error(`Erro ao configurar as paginas dos tecnicos ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarDefinicoesPaginasConfiguracaoPRT = async function(entidade, estado , req) {
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({habilitar_area_coluna_prt_tabela_pagamentos: estado})

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").info(estado === "true" ? "Coluna de PRT activo" : "Coluna de PRT desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Coluna de PRT activo" : "Coluna de PRT desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVECOLUNAPRT" : "DESACTIVECOLUNAPRT" , tabela: "CONFIGURACOES", informacao: {servico_gpo: estado, entidade}, entidade}
      });
      return rs
  
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoPRT").error(`Erro ao configurar as colunas prt na tabela de pagamentos ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarDefinicoesPaginasConfiguracaoMFT = async function(entidade, estado , req) {
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({habilitar_area_coluna_mft_tabela_pagamentos: estado})

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").info(estado === "true" ? "Coluna de MFT activa" : "Coluna de MFT ocultada")
      const rs = response("sucesso", 202, estado === "true" ? "Coluna de MFT activo" : "Coluna de MFT ocultada", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVECOLUNAMFT" : "DESACTIVECOLUNAMFT" , tabela: "CONFIGURACOES", informacao: {servico_gpo: estado, entidade}, entidade}
      });
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoMFT").error(`Erro ao configurar as colunas mft na tabela de pagamentos ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarDefinicoesPaginasConfiguracaoConcliacao = async function(entidade, estado , req) {
  try {

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({habilitar_area_coluna_concliacao_tabela_pagamentos: estado})

      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").info(estado === "true" ? "Coluna de concliação activo" : "Coluna de concliação desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Coluna de concliação activo" : "Coluna de concliação desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVECOLUNACONCILIACAO" : "DESACTIVECOLUNACONCILIACAO" , tabela: "CONFIGURACOES", informacao: {servico_gpo: estado, entidade}, entidade}
      });
      return rs

  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarDefinicoesPaginasConfiguracaoConcliacao").error(`Erro ao configurar as colunas conciliação na tabela de pagamentos ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarServicoGPO = async function(entidade, estado , req) {
  try {
      
      logger("SERVIDOR:configurarServicoGPO").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarServicoGPO").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarServicoGPO").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({servico_gpo: estado})

      logger("SERVIDOR:configurarServicoGPO").info(estado === "true" ? "Serviço de pagamento GPO activo" : "Serviço de pagamento GPO desactivo")
      const rs = response("sucesso", 202, estado === "true" ? "Serviço de pagamento GPO activo" : "Serviço de pagamento GPO desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVEGPO" : "DESACTIVEGPO" , tabela: "CONFIGURACOES", informacao: {servico_gpo: estado, entidade}, entidade}
      });
      return rs
      
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarServicoGPO").error(`Erro ao configurar o serviço GPO ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.configurarServicoPagamentoPorSector = async function(entidade, estado , req) {
  try {
      
      logger("SERVIDOR:configurarServicoPagamentoPorSector").debug(`Verificar a existencia do cliente`)
      const configuracoes = await database('clientes').where({empresaId: entidade})

      if(!configuracoes.length){
        logger("SERVIDOR:configurarServicoPagamentoPorSector").info("Cliente não foi encontrado")
        const rs = response("erro", 409, "Cliente não foi encontrado");
        return rs    
      }

      logger("SERVIDOR:configurarServicoPagamentoPorSector").debug(`Actualizar o estado para ${estado}`)
      await database('configuracoes').where({clienteIdConf: entidade}).update({servico_pagamento_por_sector: estado})

      logger("SERVIDOR:configurarServicoPagamentoPorSector").info(estado === "true" ? "Serviço de pagamento por sector activo" : "Serviço de pagamento por sector desactivo", "json")
      const rs = response("sucesso", 202, estado === "true" ? "Serviço de pagamento por sector activo" : "Serviço de pagamento por sector desactivo", "json", {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: estado === "true" ? "ACTIVESECTORPAYMENT" : "DESACTIVESECTORPAYMENT", tabela: "CONFIGURACOES", informacao: {servico_pagamento_por_sector: estado, entidade}, entidade}
      });
      return rs
    
  } catch (erro) {
      console.log(erro)
      logger("SERVIDOR:configurarServicoPagamentoPorSector").error(`Erro ao configurar o serviço pagamento por sector ${erro.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}
