const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getContatoInfo = async function(pagina, limite, total_registros, nome_colaborador, cargo_colaborador, email_colaborador, telefone_colaborador, status_colaborador, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const contato_info = await database("contato_info")
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_contato", "DESC");

      const {registros} = paginationRecords(contato_info, pagina, limite)

      const contato_infoLimite = await database("contato_info")
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_contato", "DESC");

      const filtered = usuariosFilteres(contato_infoLimite)
      
      registros.total_apresentados = contato_infoLimite.length

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getContatoInfoId = async function(id_contato) {
  try {

      const contato_info = await database("contato_info")
      .where({ id_contato })
      .orderBy("id_contato", "DESC");

      const [filtered] = usuariosFilteres(contato_info)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postContatoInfo = async function(dados, req) {
  try {

      const resultTipoReg = await database("contato_info").where({
        email: dados.email
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Email já cadastrado!`)
        const rs = response("erro", 409, "Email já cadastrado!");
        return rs
      }

      const resultTelefone = await database("contato_info").where({
        telefone: dados.telefone
      });

      if (resultTelefone.length > 0){
        logger("SERVIDOR:postClientes").info(`Telefone já cadastrado!`)
        const rs = response("erro", 409, "Telefone já cadastrado!");
        return rs
      }

      const resultLink = await database("contato_info").where({
        linkedin_url: dados.linkedin_url
      });

      if (resultLink.length > 0){
        logger("SERVIDOR:postClientes").info(`Likendin já cadastrado!`)
        const rs = response("erro", 409, "Likendin já cadastrado!");
        return rs
      }

      const resultFB = await database("contato_info").where({
        facebook_url: dados.facebook_url
      });

      if (resultFB.length > 0){
        logger("SERVIDOR:postClientes").info(`Facebook já cadastrado!`)
        const rs = response("erro", 409, "Facebook já cadastrado!");
        return rs
      }

      const resulIs = await database("contato_info").where({
        instagram_url: dados.instagram_url
      });

      if (resulIs.length > 0){
        logger("SERVIDOR:postClientes").info(`Instagram já cadastrado!`)
        const rs = response("erro", 409, "Instagram já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("contato_info").insert(dados);
      logger("SERVIDOR:Clientes").info(`ContatoInfo cadastrado com sucesso`)
      const rs = response("sucesso", 201, "ContatoInfo cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchContatoInfo = async function(id_contato, dados, req) {
  try {

      const result = await database("contato_info")
      .where({id_contato});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("ContatoInfo não encontrados")
        const rs = response("erro", 403, "ContatoInfo não encontrados");
        return rs

      }

      await database("contato_info")
        .where({ id_contato })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_contato, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteContatoInfo = async function(id_contato, req) {
  try {

      const dados = await database("contato_info").where({ id_contato })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("ContatoInfo não encontrados")
        const rs = response("erro", 403, "ContatoInfo não encontrados");
        return rs

      }

      await database("contato_info").where({ id_contato }).del();

      logger("SERVIDOR:loginClientes").info("ContatoInfo excluido feita com sucesso") 
      const rs = response("sucesso", 202, "ContatoInfo excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_contato, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
