const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getCursos = async function(pagina, limite, total_registros, titulo, descricao_curta, descricao_longa, preco, duracao, data_inicio, data_fim, destaque, status, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const cursos = await database("cursos")
      .whereLike("titulo",`%${titulo}%`)
      .whereLike("descricao_curta",`%${descricao_curta}%`)
      .whereLike("descricao_longa",`%${descricao_longa}%`)
      .whereLike("preco",`%${preco}%`)
      .whereLike("duracao",`%${duracao}%`)
      .whereLike("data_inicio",`%${data_inicio}%`)
      .whereLike("data_fim",`%${data_fim}%`)
      .whereLike("destaque",`%${destaque}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_criacao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_cursos", "DESC");

      const {registros} = paginationRecords(cursos, pagina, limite)

      const cursosLimite = await database("cursos")
      .whereLike("titulo",`%${titulo}%`)
      .whereLike("descricao_curta",`%${descricao_curta}%`)
      .whereLike("descricao_longa",`%${descricao_longa}%`)
      .whereLike("preco",`%${preco}%`)
      .whereLike("duracao",`%${duracao}%`)
      .whereLike("data_inicio",`%${data_inicio}%`)
      .whereLike("data_fim",`%${data_fim}%`)
      .whereLike("destaque",`%${destaque}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_criacao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_cursos", "DESC");

      const filtered = usuariosFilteres(cursosLimite)
      
      registros.total_apresentados = cursosLimite.length
      registros.titulo = titulo
      registros.descricao_curta = descricao_curta
      registros.descricao_longa = descricao_longa
      registros.preco = preco
      registros.duracao = duracao
      registros.destaque = destaque
      registros.data_inicio = data_inicio
      registros.data_fim = data_fim
      registros.status = status
      registros.criacao = data_criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getCursosId = async function(id_cursos) {
  try {

      const cursos = await database("cursos")
      .where({ id_cursos })
      .orderBy("id_cursos", "DESC");

      const [filtered] = usuariosFilteres(cursos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postCursos = async function(dados, req) {
  try {

      const resultTipoReg = await database("cursos").where({
        titulo: dados.titulo
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Titulo já cadastrado!`)
        const rs = response("erro", 409, "Titulo já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("cursos").insert(dados);
      logger("SERVIDOR:Clientes").info(`Cursos cadastrado com sucesso`)
      const rs = response("sucesso", 201, "Cursos cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchCursos = async function(id_cursos, dados, req) {
  try {

      const result = await database("cursos")
      .where({id_cursos});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("Cursos não encontrados")
        const rs = response("erro", 403, "Cursos não encontrados");
        return rs

      }

      await database("cursos")
        .where({ id_cursos })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_cursos, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteCursos = async function(id_cursos, req) {
  try {

      const dados = await database("cursos").where({ id_cursos })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("Cursos não encontrados")
        const rs = response("erro", 403, "Cursos não encontrados");
        return rs

      }

      await database("cursos").where({ id_cursos }).del();

      logger("SERVIDOR:loginClientes").info("Cursos excluido feita com sucesso") 
      const rs = response("sucesso", 202, "Cursos excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_cursos, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
