const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getEstudantes = async function(pagina, limite, total_registros, nome, nif, email, telefone, data_nascimento, genero, status, criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const estudantes = await database("estudantes")
      .whereLike("nome",`%${nome}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_nascimento",`%${data_nascimento}%`)
      .whereLike("genero",`%${genero}%`)
      .whereLike("data_cadastro",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_estudantes", "DESC");

      const {registros} = paginationRecords(estudantes, pagina, limite)

      const estudantesLimite = await database("estudantes")
      .whereLike("nome",`%${nome}%`)
      .whereLike("nif",`%${nif}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_nascimento",`%${data_nascimento}%`)
      .whereLike("genero",`%${genero}%`)
      .whereLike("data_cadastro",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_estudantes", "DESC");

      const filtered = usuariosFilteres(estudantesLimite)
      
      registros.total_apresentados = estudantesLimite.length
      registros.nome = nome
      registros.email = email
      registros.cargo = nif
      registros.status = status
      registros.telefone = telefone
      registros.data_nascimento = data_nascimento
      registros.genero = genero
      registros.criacao = criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getEstudantesId = async function(id_estudantes) {
  try {

      const estudantes = await database("estudantes")
      .where({ id_estudantes })
      .orderBy("id_estudantes", "DESC");

      const [filtered] = usuariosFilteres(estudantes)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postEstudantes = async function(dados, req) {
  try {

      const resultTipoReg = await database("estudantes").where({
        email: dados.email
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Email já cadastrado!`)
        const rs = response("erro", 409, "Email já cadastrado!");
        return rs
      }

      const resultTelefone = await database("estudantes").where({
        telefone: dados.telefone
      });

      if (resultTelefone.length > 0){
        logger("SERVIDOR:postClientes").info(`Telefone já cadastrado!`)
        const rs = response("erro", 409, "Telefone já cadastrado!");
        return rs
      }

      const resultLink = await database("estudantes").where({
        nif: dados.nif
      });

      if (resultLink.length > 0){
        logger("SERVIDOR:postClientes").info(`NIF já cadastrado!`)
        const rs = response("erro", 409, "NIF já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("estudantes").insert(dados);
      logger("SERVIDOR:Clientes").info(`Estudantes cadastrado com sucesso`)
      const rs = response("sucesso", 201, "Estudantes cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchEstudantes = async function(id_estudantes, dados, req) {
  try {

      const result = await database("estudantes")
      .where({id_estudantes});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("Estudantes não encontrados")
        const rs = response("erro", 403, "Estudantes não encontrados");
        return rs

      }

      await database("estudantes")
        .where({ id_estudantes })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_estudantes, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteEstudantes = async function(id_estudantes, req) {
  try {

      const dados = await database("estudantes").where({ id_estudantes })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("Estudantes não encontrados")
        const rs = response("erro", 403, "Estudantes não encontrados");
        return rs

      }

      await database("estudantes").where({ id_estudantes }).del();

      logger("SERVIDOR:loginClientes").info("Estudantes excluido feita com sucesso") 
      const rs = response("sucesso", 202, "Estudantes excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_estudantes, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
