const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const { v4: uuidv4 } = require('uuid');
const {pedidoCotacaoFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getFactura = async function(pagina, limite, total_registros, numeroFactura, valorTotal, statusFactura, dataVencimento, dataPagamento, formaPagamento, descricao, dataEmissao, req) {
     
    try{

        logger("SERVIDOR:getFactura").debug("Á carregar dados")
        const factura = await database('factura')
        .join("cliente","cliente.clienteId","=","factura.clienteIdFac")
        .join("pedidocotacao","pedidocotacao.pedidoCotacaoId","=","factura.cotacaoId")
        .join("empresa","empresa.empresaId","=","factura.empresaIdFac")
        .whereLike("numeroFactura",`%${numeroFactura}%`)
        .whereLike("valorTotalFactura",`%${valorTotal}%`)
        .whereLike("statusFactura",`%${statusFactura}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("formaPagamento",`%${formaPagamento}%`)
        .whereLike("dataVencimento",`%${dataVencimento}%`)
        .whereLike("dataPagamento",`%${dataPagamento}%`)
        .whereLike("dataEmissao",`%${dataEmissao}%`)
        .orWhereNull("formaPagamento")
        .orWhereNull("dataPagamento")
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')

        const {registros} = paginationRecords(factura, pagina, limite)

        logger("SERVIDOR:getFactura").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('factura')
        .join("cliente","cliente.clienteId","=","factura.clienteIdFac")
        .join("pedidocotacao","pedidocotacao.pedidoCotacaoId","=","factura.cotacaoId")
        .join("empresa","empresa.empresaId","=","factura.empresaIdFac")
        .whereLike("numeroFactura",`%${numeroFactura}%`)
        .whereLike("valorTotalFactura",`%${valorTotal}%`)
        .whereLike("statusFactura",`%${statusFactura}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("formaPagamento",`%${formaPagamento}%`)
        .whereLike("dataVencimento",`%${dataVencimento}%`)
        .whereLike("dataPagamento",`%${dataPagamento}%`)
        .whereLike("dataEmissao",`%${dataEmissao}%`)
        .orWhereNull("formaPagamento")
        .orWhereNull("dataPagamento")
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc')
        
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.numeroFactura = numeroFactura
        registros.valorTotal = valorTotal
        registros.statusFactura = statusFactura
        registros.descricao = descricao
        registros.formaPagamento = formaPagamento
        registros.dataVencimento = dataVencimento
        registros.dataPagamento = dataPagamento
        registros.dataEmissao = dataEmissao

        delete registros.count

        logger("SERVIDOR:getFactura").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs

    
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFactura").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}


module.exports.getFacturaId = async function(facturaId) {
     
     try{

        logger("SERVIDOR:getFacturaId").debug("Á carregar dados")
        const factura = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .where({facturaId})
        .orderBy('facturaId','desc')
        
        const [filtered] = pedidoCotacaoFilteres(factura)

        logger("SERVIDOR:getFacturaId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered || {});            
        return rs      
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getFacturaclienteId = async function(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getFacturaclienteId").debug("Á carregar dados")
        const factura = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')
      
        const {registros} = paginationRecords(factura, pagina, limite)

        logger("SERVIDOR:getFacturaclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getFacturaclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getFacturaEntidadeclienteId = async function(empresaId, clienteId, pagina, limite, total_registros, numeroFactura, valorTotal, statusFactura, dataVencimento, dataPagamento, formaPagamento, descricao, dataEmissao, req) {
     
     try{

        logger("SERVIDOR:getFacturaEntidadeclienteId").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})   
        
        console.log(empresaId, clienteId)

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getFacturaEntidadeclienteId").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getFacturaEntidadeclienteId").debug("Á carregar dados")
        const factura = await database('factura')
        .join("cliente","cliente.clienteId","=","factura.clienteIdFac")
        .join("pedidocotacao","pedidocotacao.pedidoCotacaoId","=","factura.cotacaoId")
        .join("empresa","empresa.empresaId","=","factura.empresaIdFac")
        .whereLike("numeroFactura",`%${numeroFactura}%`)
        .whereLike("valorTotalFactura",`%${valorTotal}%`)
        .whereLike("statusFactura",`%${statusFactura}%`)
        .whereLike("descricao",`%${descricao}%`)
        // .whereLike("formaPagamento",`%${formaPagamento}%`)
        .whereLike("dataVencimento",`%${dataVencimento}%`)
        // .whereLike("dataPagamento",`%${dataPagamento}%`)
        .whereLike("dataEmissao",`%${dataEmissao}%`)
        .where({empresaIdFac: empresaId})
        .andWhere({clienteIdFac: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')
      
        const {registros} = paginationRecords(factura, pagina, limite)

        logger("SERVIDOR:getFacturaEntidadeclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('factura')
        .join("cliente","cliente.clienteId","=","factura.clienteIdFac")
        .join("pedidocotacao","pedidocotacao.pedidoCotacaoId","=","factura.cotacaoId")
        .join("empresa","empresa.empresaId","=","factura.empresaIdFac")
        .whereLike("numeroFactura",`%${numeroFactura}%`)
        .whereLike("valorTotalFactura",`%${valorTotal}%`)
        .whereLike("statusFactura",`%${statusFactura}%`)
        .whereLike("descricao",`%${descricao}%`)
        // .whereLike("formaPagamento",`%${formaPagamento}%`)
        .whereLike("dataVencimento",`%${dataVencimento}%`)
        // .whereLike("dataPagamento",`%${dataPagamento}%`)
        .whereLike("dataEmissao",`%${dataEmissao}%`)
        .where({empresaIdFac: empresaId})
        .andWhere({clienteIdFac: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.numeroFactura = numeroFactura
        registros.valorTotal = valorTotal
        registros.statusFactura = statusFactura
        registros.descricao = descricao
        registros.formaPagamento = formaPagamento
        registros.dataVencimento = dataVencimento
        registros.dataPagamento = dataPagamento
        registros.dataEmissao = dataEmissao

        delete registros.count

        logger("SERVIDOR:getFacturaEntidadeclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getFacturaEntidadeGrupoAfiliados = async function(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getFacturaEntidadeGrupoAfiliados").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getFacturaEntidadeGrupoAfiliados").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        const factura = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')

        const {registros} = paginationRecords(factura, pagina, limite)

        const pedidoCotacaoLimite = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc')
      
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getFacturaEntidadeGrupoAfiliados").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaEntidadeGrupoAfiliados").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getFacturaEntidade = async function(empresaId, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora_transacao, data_transacao, req) {
     
     try{

        logger("SERVIDOR:getFacturaEntidade").debug("Á carregar dados de configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getFacturaEntidade").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getFacturaEntidade").debug("Á carregar dados")
        const factura = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora_transacao}%`)
        .whereLike("data_movimento",`%${data_transacao}%`)
        .where({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')    
      
        const {registros} = paginationRecords(factura, pagina, limite)

        logger("SERVIDOR:getFacturaEntidade").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora_transacao}%`)
        .whereLike("data_movimento",`%${data_transacao}%`)
        .where({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc')
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora_transacao = hora_transacao
        registros.data_transacao = data_transacao

        delete registros.count

        logger("SERVIDOR:getFacturaEntidade").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaEntidade").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getFacturaPeriodo = async function(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getFacturaPeriodo").debug("Á carregar dados")
      const factura = await database('factura')
      .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('facturaId','desc')  
              
      const {registros} = paginationRecords(factura, pagina, limite)

      logger("SERVIDOR:getFacturaPeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('factura')
      .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('facturaId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getFacturaPeriodo").info("Respondeu a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getFacturaPeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getFacturaEntidadePeriodo = async function(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getFacturaEntidadePeriodo").debug("Á carregar dados da configuração")
      const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

      if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
        logger("SERVIDOR:getFacturaEntidadePeriodo").info("Serviço de pagamento por sector inactivo")
        const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
        return rs
      }

      logger("SERVIDOR:getFacturaEntidadePeriodo").debug("Á carregar dados")
      const factura = await database('factura')
      .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('facturaId','desc')  
              
      const {registros} = paginationRecords(factura, pagina, limite)

      logger("SERVIDOR:getFacturaEntidadePeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('factura')
      .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('facturaId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = empresaId
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getFacturaEntidadePeriodo").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getFacturaEntidadePeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getFacturaEntidadeDias = async function(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getFacturaEntidadeDias").debug("Á carregar dados da configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getFacturaEntidadeDias").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getFacturaEntidadeDias").debug("Á carregar dados")
        const factura = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')          
        
        const {registros} = paginationRecords(factura, pagina, limite)

        logger("SERVIDOR:getFacturaEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora
  
        logger("SERVIDOR:getFacturaEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaEntidadeDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getFacturaDias = async function(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{
      
        logger("SERVIDOR:getFacturaEntidadeDias").debug("Á carregar dados")
        const factura = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .limit(total_registros || pagination.total_limite)
        .orderBy('facturaId','desc')          
        
        const {registros} = paginationRecords(factura, pagina, limite)

        logger("SERVIDOR:getFacturaEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('factura')
        .join("clienteIds","clienteIds.num_clienteId","=","factura.clienteIdFac_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('facturaId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        logger("SERVIDOR:getFacturaEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getFacturaEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.postPagarFacturas = async function(dados, req) {
  try {

      const resultCliente = await database("cliente")
      .where({clienteId: dados.clienteIdFac})
      .andWhere({empresaId: dados.empresaIdFac});

      if (resultCliente.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "Seu usuario não encontrado");
        return rs

      }

      const resultProduto = await database("pedidocotacao")
      .where({pedidoCotacaoId: dados.cotacaoId})
      .andWhere({clienteIdPedido: dados.clienteIdFac})
      .andWhere({empresaID: dados.empresaIdFac});

      if (resultProduto.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "A contação dessa factura não existe ou ja é invalida");
        return rs

      }

      const resultFactura = await database("factura")
      .where({facturaId: dados.facturaId})

      if (resultFactura.length == 0) {

        logger("SERVIDOR:loginClientes").info("Registro não encontrado")
        const rs = response("erro", 409, "Factura não existe ou ja é invalida");
        return rs

      }

      if (resultFactura[0].statusFactura == "Emitida") {

          const actualizado_em = new Date().toISOString().replace('T',' ').substr(0,19)

          if(resultFactura[0].formaPagamento == "Liquidação Sistema"){

            const resultContaSaldo = await database("conta_saldo")
            .where({empresaIdSaldo: dados.empresaIdFac})
            .andWhere({clienteIdSaldo: dados.clienteIdFac})

            if (resultContaSaldo.length == 0) {

              logger("SERVIDOR:loginClientes").info("Registro não encontrado")
              const rs = response("erro", 409, "Ainda estás sem registo de saldo ou saldo indisponivel");
              return rs

            }

              const saldo = resultContaSaldo[0].saldoAtual
              const precoFactura = resultFactura[0].valorTotalFactura
              const resultadoSubtracao = Number(saldo) - Number(precoFactura)
              const resultadoSoma = Number(resultadoSubtracao) + Number(precoFactura)

              await database("conta_saldo")
              .where({empresaIdSaldo: dados.empresaIdFac})
              .andWhere({clienteIdSaldo: dados.clienteIdFac})
              .update({saldoAtual: resultadoSubtracao})

              await database("movimento_financeiro").insert(
                { 
                  tipoMovimento: "Saída",
                  valor: resultFactura[0].valorTotalFactura,
                  referenciaTipo: "Débito",
                  referenciaId: uuidv4(),
                  empresaIdMov: dados.empresaIdFac,
                  clienteIdMov: dados.clienteIdFac, 
                  objecto: dados.facturaId,
                  observacoesFinanceiros: "Pagamento recebido do cliente",
                  descricao: `Pagamento de fatura #${dados.facturaId}` 
                }
              );


              logger("SERVIDOR:loginClientes").debug("Registrando")
              await database("factura").where({facturaId: dados.facturaId}).update({ statusFactura: "Paga", dataPagamento: actualizado_em });
              logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
              const rs = response("sucesso", 201, "Pagamento feito com sucesso", "json",{
                info:{
                  ...dados
                }
              })

              return rs

          }


          logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
          const rs = response("erro", 209, "Metodo de pagamento invalido", "json",{
            info:{
              ...dados
            }
          })

          return rs

      }
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("erro", 409, "Pagamento não foi feito com sucesso", "json",{
        info:{
          ...dados
        }
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
