const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getFaleConosco = async function(pagina, limite, total_registros,  nome, lido, email, mensagem, telefone, assunto, origem, criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const fale_conosco = await database("fale_conosco")
      .whereLike("nome",`%${nome}%`)
      .whereLike("lido",`%${lido}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("mensagem",`%${mensagem}%`)
      .whereLike("assunto",`%${assunto}%`)
      .whereLike("origem",`%${origem}%`)
      .whereLike("data_envio",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_fale_conosco", "DESC");

      const {registros} = paginationRecords(fale_conosco, pagina, limite)

      const fale_conoscoLimite = await database("fale_conosco")
      .whereLike("nome",`%${nome}%`)
      .whereLike("lido",`%${lido}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("mensagem",`%${mensagem}%`)
      .whereLike("assunto",`%${assunto}%`)
      .whereLike("origem",`%${origem}%`)
      .whereLike("data_envio",`%${criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_fale_conosco", "DESC");

      const filtered = usuariosFilteres(fale_conoscoLimite)
      
      registros.total_apresentados = fale_conoscoLimite.length
      registros.nome = nome
      registros.email = email
      registros.lido = lido
      registros.assunto = assunto
      registros.telefone = mensagem
      registros.mensagem = mensagem
      registros.origem = origem
      registros.criacao = criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getFaleConoscoId = async function(id_fale_conosco) {
  try {

      const fale_conosco = await database("fale_conosco")
      .where({ id_fale_conosco })
      .orderBy("id_fale_conosco", "DESC");

      const [filtered] = usuariosFilteres(fale_conosco)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postFaleConosco = async function(dados, req) {
  try {


      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("fale_conosco").insert(dados);
      logger("SERVIDOR:Clientes").info(`FaleConosco cadastrado com sucesso`)
      const rs = response("sucesso", 201, "FaleConosco cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchFaleConosco = async function(id_fale_conosco, dados, req) {
  try {

      const result = await database("fale_conosco")
      .where({id_fale_conosco});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("FaleConosco não encontrados")
        const rs = response("erro", 403, "FaleConosco não encontrados");
        return rs

      }

      await database("fale_conosco")
        .where({ id_fale_conosco })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_fale_conosco, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteFaleConosco = async function(id_fale_conosco, req) {
  try {

      const dados = await database("fale_conosco").where({ id_fale_conosco })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("FaleConosco não encontrados")
        const rs = response("erro", 403, "FaleConosco não encontrados");
        return rs

      }

      await database("fale_conosco").where({ id_fale_conosco }).del();

      logger("SERVIDOR:loginClientes").info("FaleConosco excluido feita com sucesso") 
      const rs = response("sucesso", 202, "FaleConosco excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_fale_conosco, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
