const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getNewsletterInscricoes = async function(pagina, limite, total_registros, nome, origem, email, status, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const newsletter_inscricoes = await database("newsletter_inscricoes")
      .whereLike("nome",`%${nome}%`)
      .whereLike("origem",`%${origem}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_inscricao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_newsletter_inscricoes", "DESC");

      const {registros} = paginationRecords(newsletter_inscricoes, pagina, limite)

      const newsletter_inscricoesLimite = await database("newsletter_inscricoes")
      .whereLike("nome",`%${nome}%`)
      .whereLike("origem",`%${origem}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_inscricao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_newsletter_inscricoes", "DESC");

      const filtered = usuariosFilteres(newsletter_inscricoesLimite)
      
      registros.total_apresentados = newsletter_inscricoesLimite.length
      registros.nome = nome
      registros.email = email
      registros.origem = origem
      registros.status = status
      registros.criacao = data_criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getNewsletterInscricoesId = async function(id_newsletter_inscricoes) {
  try {

      const newsletter_inscricoes = await database("newsletter_inscricoes")
      .where({ id_newsletter_inscricoes })
      .orderBy("id_newsletter_inscricoes", "DESC");

      const [filtered] = usuariosFilteres(newsletter_inscricoes)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postNewsletterInscricoes = async function(dados, req) {
  try {

      const resultTipoReg = await database("newsletter_inscricoes").where({
        email: dados.email
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Email já cadastrado!`)
        const rs = response("erro", 409, "Email já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("newsletter_inscricoes").insert(dados);
      logger("SERVIDOR:Clientes").info(`NewsletterInscricoes cadastrado com sucesso`)
      const rs = response("sucesso", 201, "NewsletterInscricoes cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchNewsletterInscricoes = async function(id_newsletter_inscricoes, dados, req) {
  try {

      const result = await database("newsletter_inscricoes")
      .where({id_newsletter_inscricoes});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("NewsletterInscricoes não encontrados")
        const rs = response("erro", 403, "NewsletterInscricoes não encontrados");
        return rs

      }

      await database("newsletter_inscricoes")
        .where({ id_newsletter_inscricoes })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_newsletter_inscricoes, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteNewsletterInscricoes = async function(id_newsletter_inscricoes, req) {
  try {

      const dados = await database("newsletter_inscricoes").where({ id_newsletter_inscricoes })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("NewsletterInscricoes não encontrados")
        const rs = response("erro", 403, "NewsletterInscricoes não encontrados");
        return rs

      }

      await database("newsletter_inscricoes").where({ id_newsletter_inscricoes }).del();

      logger("SERVIDOR:loginClientes").info("NewsletterInscricoes excluido feita com sucesso") 
      const rs = response("sucesso", 202, "NewsletterInscricoes excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_newsletter_inscricoes, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
