const database = require('../config/database')
const response = require("../constants/response");
const pagination = require("../constants/pagination");
const logger = require('../services/loggerService');
const {pedidoCotacaoFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords")

module.exports.getProdutos = async function(pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req) {
     
    try{

        logger("SERVIDOR:getProdutos").debug("Á carregar dados")
        const produto = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')

        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getProdutos").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")  
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')
        
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.codigoProduto = codigoProduto
        registros.descricao = descricao
        registros.unidadeMedida = unidadeMedida
        registros.preco = preco
        registros.categoria = categoria
        registros.ativo = ativo
        registros.dataProduto = dataProduto

        delete registros.count

        logger("SERVIDOR:getProdutos").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs

    
    } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutos").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}


module.exports.getProdutosId = async function(produtoId) {
     
     try{

        logger("SERVIDOR:getProdutosId").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .where({produtoId})
        .orderBy('produtoId','desc')
        
        const [filtered] = pedidoCotacaoFilteres(produto)

        logger("SERVIDOR:getProdutosId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered || {});            
        return rs      
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getProdutosclienteId = async function(clienteId, pagina, limite, total_registros, entidade, montante, tarifa, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getProdutosclienteId").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')
      
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getProdutosclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .where({clienteId_do_servico: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getProdutosclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getProdutosEntidadeclienteId = async function(empresaId, clienteId, pagina, limite, total_registros, montante, tarifa, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getProdutosEntidadeclienteId").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getProdutosEntidadeclienteId").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getProdutosEntidadeclienteId").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({clienteId_do_servico: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')
      
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getProdutosEntidadeclienteId").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({clienteId_do_servico: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc') 
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getProdutosEntidadeclienteId").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getProdutosEntidadeGrupoAfiliados = async function(empresaId, grupo_identificacao, pagina, limite, total_registros, montante, tarifa, clienteId, periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getProdutosEntidadeGrupoAfiliados").debug("Á carregar dados")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getProdutosEntidadeGrupoAfiliados").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')

        const {registros} = paginationRecords(produto, pagina, limite)

        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("afiliados","afiliados.id_afiliado","=","clienteIds.gerado_por_afiliado")
        .join("identificacao_afiliados","identificacao_afiliados.id_identificacao_afiliados","=","afiliados.grupo_identificacao")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .where({empresaId})
        .andWhere({grupo_identificacao})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')
      
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        delete registros.count

        logger("SERVIDOR:getProdutosEntidadeGrupoAfiliados").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
     
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosEntidadeGrupoAfiliados").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getProdutosEntidade = async function(empresaId, pagina, limite, total_registros, codigoProduto, descricao, unidadeMedida, preco, categoria, ativo, dataProduto, req) {
     
     try{

        logger("SERVIDOR:getProdutosEntidade").debug("Á carregar dados de configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if((verifivarPagamentoTempoReal?.servico_principal == "false")){
          logger("SERVIDOR:loginClientes").warn("Serviço de gestão inactivo")
          const rs = response("erro", 423, "Serviço de gestão inactivo");
          return rs     
        }

        logger("SERVIDOR:getProdutosEntidade").debug("Á carregar dados")
        const produto = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .where({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')    
      
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getProdutosEntidade").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("empresa","empresa.empresaId","=","produto.empresaDona")
        .whereLike("codigoProduto",`%${codigoProduto}%`)
        .whereLike("descricao",`%${descricao}%`)
        .whereLike("unidadeMedida",`%${unidadeMedida}%`)
        .whereLike("preco",`%${preco}%`)
        .whereLike("categoria",`%${categoria}%`)
        .whereLike("ativo",`%${ativo}%`)
        .whereLike("dataProduto",`%${dataProduto}%`)
        .where({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')
      
        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.codigoProduto = codigoProduto
        registros.descricao = descricao
        registros.unidadeMedida = unidadeMedida
        registros.preco = preco
        registros.categoria = categoria
        registros.ativo = ativo
        registros.dataProduto = dataProduto

        delete registros.count

        logger("SERVIDOR:getProdutosEntidade").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros,
          url: req.originalUrl
        });
            
        return rs
      
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosEntidade").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getProdutosPeriodo = async function(periodo, pagina, limite, total_registros, entidade, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getProdutosPeriodo").debug("Á carregar dados")
      const produto = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('produtoId','desc')  
              
      const {registros} = paginationRecords(produto, pagina, limite)

      logger("SERVIDOR:getProdutosPeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .whereLike("empresaId",`%${entidade}%`)
      .where({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('produtoId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = entidade
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getProdutosPeriodo").info("Respondeu a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getProdutosPeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getProdutosEntidadePeriodo = async function(empresaId, periodo, pagina, limite, total_registros, montante, tarifa, clienteId, log_transacao, terminal, nib, hora) {
     
  try{

      logger("SERVIDOR:getProdutosEntidadePeriodo").debug("Á carregar dados da configuração")
      const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

      if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
        logger("SERVIDOR:getProdutosEntidadePeriodo").info("Serviço de pagamento por sector inactivo")
        const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
        return rs
      }

      logger("SERVIDOR:getProdutosEntidadePeriodo").debug("Á carregar dados")
      const produto = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(total_registros || pagination.total_limite)
      .orderBy('produtoId','desc')  
              
      const {registros} = paginationRecords(produto, pagina, limite)

      logger("SERVIDOR:getProdutosEntidadePeriodo").debug("Á carregar dados com limite")
      const pedidoCotacaoLimite = await database('produto')
      .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
      .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
      .join("tipo_produto","tipo_produto.id_tipo_produto","=","clienteIds.tipo_de_registro")    
      .whereLike("montante_da_operacao",`%${montante}%`)
      .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
      .whereLike("clienteId_do_servico",`%${clienteId}%`)
      .whereLike("numero_Log_EGR",`%${log_transacao}%`)
      .whereLike("tipo_de_Terminal",`%${terminal}%`)
      .whereLike("nib",`%${nib}%`)
      .whereLike("hora_do_movimento",`%${hora}%`)
      .where({empresaId})
      .andWhere({Identificacao_Log_EGR:periodo})
      .limit(registros.limite)
      .offset(registros.count)
      .orderBy('produtoId','desc')
      
      const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
      registros.total_apresentados = pedidoCotacaoLimite.length
      registros.entidade = empresaId
      registros.periodo = periodo
      registros.montante = montante
      registros.tarifa = tarifa
      registros.clienteId = clienteId
      registros.log_transacao = log_transacao
      registros.terminal = terminal
      registros.nib = nib
      registros.hora = hora

      logger("SERVIDOR:getProdutosEntidadePeriodo").info("Respondendo a requisição")
      const rs = response("sucesso", 200, filtered, "json",
      {
        registros
      });
          
      return rs 
   
  } catch (error) {
      console.error(error.message)
      logger("SERVIDOR:getProdutosEntidadePeriodo").error("Erro a buscar os dados "+error.message)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
 }
 
}

module.exports.getProdutosEntidadeDias = async function(empresaId, dia_inicio, dia_final, pagina, limite, total_registros, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{

        logger("SERVIDOR:getProdutosEntidadeDias").debug("Á carregar dados da configuração")
        const verifivarPagamentoTempoReal = await database('configuracoes').where({clienteIdConf: empresaId})        

        if(((verifivarPagamentoTempoReal[0]?.servico_pagamento_por_sector == "false") && (verifivarPagamentoTempoReal[0]?.servico_gpo == "false"))){
          logger("SERVIDOR:getProdutosEntidadeDias").info("Serviço de pagamento por sector inactivo")
          const rs = response("erro", 423, "Serviço de pagamento por sector inactivo");
          return rs
        }

        logger("SERVIDOR:getProdutosEntidadeDias").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')          
        
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getProdutosEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .andWhere({empresaId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.entidade = empresaId
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora
  
        logger("SERVIDOR:getProdutosEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosEntidadeDias").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getProdutosDias = async function(dia_inicio, dia_final, pagina, limite, total_registros, entidade, montante, tarifa, clienteId,  periodo, log_transacao, terminal, nib, hora) {
     
     try{
      
        logger("SERVIDOR:getProdutosEntidadeDias").debug("Á carregar dados")
        const produto = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_movimento",[dia_inicio, dia_final])
        .limit(total_registros || pagination.total_limite)
        .orderBy('produtoId','desc')          
        
        const {registros} = paginationRecords(produto, pagina, limite)

        logger("SERVIDOR:getProdutosEntidadeDias").debug("Á carregar dados com limite")
        const pedidoCotacaoLimite = await database('produto')
        .join("clienteIds","clienteIds.num_clienteId","=","produto.clienteId_do_servico")
        .join("produtos_clientes","produtos_clientes.id_produto","=","clienteIds.indicador_produto_id")
        .whereLike("montante_da_operacao",`%${montante}%`)
        .whereLike("tarifa_aplicada_a_operacao",`%${tarifa}%`)
        .whereLike("clienteId_do_servico",`%${clienteId}%`)
        .whereLike("Identificacao_Log_EGR",`%${periodo}%`)
        .whereLike("numero_Log_EGR",`%${log_transacao}%`)
        .whereLike("tipo_de_Terminal",`%${terminal}%`)
        .whereLike("nib",`%${nib}%`)
        .whereLike("hora_do_movimento",`%${hora}%`)
        .whereLike("empresaId",`%${entidade}%`)
        .whereBetween("data_do_processamento",[dia_inicio, dia_final])
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('produtoId','desc')

        const filtered = pedidoCotacaoFilteres(pedidoCotacaoLimite)
        registros.total_apresentados = pedidoCotacaoLimite.length
        registros.dia_inicio = dia_inicio
        registros.dia_final = dia_final
        registros.entidade = entidade
        registros.periodo = periodo
        registros.montante = montante
        registros.tarifa = tarifa
        registros.clienteId = clienteId
        registros.log_transacao = log_transacao
        registros.terminal = terminal
        registros.nib = nib
        registros.hora = hora

        logger("SERVIDOR:getProdutosEntidadeDias").info("Respondendo a requisição")
        const rs = response("sucesso", 200, filtered, "json",
        {
          registros
        });
            
        return rs
        
      
     } catch (error) {
        console.error(error.message)
        logger("SERVIDOR:getProdutosEntidadeclienteId").error("Erro a buscar os dados "+error.message)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}
