const database = require('../config/database')
const fs = require('fs')
const path = require('path');
const pagination = require("../constants/pagination");
const response = require("../constants/response");
const logger = require('../services/loggerService');
const {relatoriosFilteres} = require("../helpers/filterResponseSQL")
const paginationRecords = require("../helpers/paginationRecords");


module.exports.getRelatorios = async function(pagina, limite, total_registros, nome_empresa, email, entidade) {
     
     try{

        const relatorios = await database('relatorios')
        .join("cliente","cliente.empresaId","=","relatorios.entidade")
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_relatorio','desc')


        const {registros} = paginationRecords(relatorios, pagina, limite)

        const relatoriosLimite = await database('relatorios')
        .join("cliente","cliente.empresaId","=","relatorios.entidade")
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_relatorio','desc')
        
        const filtered = relatoriosFilteres(relatoriosLimite)
        registros.total_apresentados = relatoriosLimite.length
        registros.nome_empresa = nome_empresa
        registros.email = email
        registros.entidade = entidade
  
        delete registros.count
  
        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, filtered, "json", { registros });
        return rs
      
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:Clientes").error(`Erro ao buscar cliente ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getRelatoriosId = async function(id_relatorio) { 
     
     try{
        const relatorios = await database('relatorios')
        .join("cliente","cliente.empresaId","=","relatorios.entidade") 
        .where({id_relatorio})
        .orderBy('id_relatorio','desc')

        const filtered = relatoriosFilteres(relatorios)
        
        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, filtered);
        return rs   
      
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:Clientes").error(`Erro ao buscar cliente ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getRelatoriosEntidade = async function(pagina, limite, total_registros, empresaId, clienteId) {
     
     try{

        const relatorios = await database('relatorios')
        .join("cliente","cliente.clienteId","=","relatorios.clienteRelatorio")
        .join("empresa","empresa.empresaId","=","relatorios.empresaRelatorio")
        .where({empresaRelatorio: empresaId})
        .andWhere({clienteRelatorio: clienteId})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_relatorio','desc')

        const {registros} = paginationRecords(relatorios, pagina, limite)

        const relatoriosLimite = await database('relatorios')
        .join("cliente","cliente.clienteId","=","relatorios.clienteRelatorio")
        .join("empresa","empresa.empresaId","=","relatorios.empresaRelatorio")
        .where({empresaRelatorio: empresaId})
        .andWhere({clienteRelatorio: clienteId})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_relatorio','desc')
        
        const filtered = relatoriosFilteres(relatoriosLimite)

        registros.total_apresentados = relatoriosLimite.length
        registros.entidade = empresaId
        registros.cliente = clienteId
        
        delete registros.count
  
        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, filtered, "json", { registros });
        return rs
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:Clientes").error(`Erro ao buscar cliente ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getRelatoriosEntidadeEmpresaTipo = async function(pagina, limite, total_registros, empresaId, clienteId, tipo) {
     
     try{

        const relatorios = await database('relatorios')
        .join("cliente","cliente.clienteId","=","relatorios.clienteRelatorio")
        .join("empresa","empresa.empresaId","=","relatorios.empresaRelatorio")
        .where({empresaRelatorio: empresaId})
        .andWhere({clienteRelatorio: clienteId})
        .andWhere({para: tipo})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_relatorio','desc')

        const {registros} = paginationRecords(relatorios, pagina, limite)

        const relatoriosLimite = await database('relatorios')
        .join("cliente","cliente.clienteId","=","relatorios.clienteRelatorio")
        .join("empresa","empresa.empresaId","=","relatorios.empresaRelatorio")
        .where({empresaRelatorio: empresaId})
        .andWhere({para: tipo})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_relatorio','desc')
        
        const filtered = relatoriosFilteres(relatoriosLimite)

        registros.total_apresentados = relatoriosLimite.length
        registros.entidade = empresaId
        registros.cliente = clienteId
        
        delete registros.count
  
        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, filtered, "json", { registros });
        return rs
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:Clientes").error(`Erro ao buscar cliente ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.getRelatoriosEntidadeTipo = async function(pagina, limite, total_registros, entidade, para) {
     
     try{

        const relatorios = await database('relatorios')
        .join("cliente","cliente.empresaId","=","relatorios.entidade")
        .where({entidade})
        .andWhere({para})
        .limit(total_registros || pagination.total_limite)
        .orderBy('id_relatorio','desc')

        const {registros} = paginationRecords(relatorios, pagina, limite)

        const relatoriosLimite = await database('relatorios')
        .join("cliente","cliente.empresaId","=","relatorios.entidade")
        .where({entidade})
        .andWhere({para})
        .limit(registros.limite)
        .offset(registros.count)
        .orderBy('id_relatorio','desc')
        
        const filtered = relatoriosFilteres(relatoriosLimite)

        registros.total_apresentados = relatoriosLimite.length
        registros.entidade = entidade
        registros.para = para
        
        delete registros.count
  
        logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
        const rs = response("sucesso", 200, filtered, "json", { registros });
        return rs
      
     } catch (error) {
        console.log(error)
        logger("SERVIDOR:Clientes").error(`Erro ao buscar cliente ${error.message}`)
        const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
        return rs
    }
    
}

module.exports.postRelatorios = async function({empresa, cliente, tipo, campos}) {

    
    try {

      const filename = new Date().toISOString().split('Z')[0].replaceAll('-','').replaceAll('T','').replaceAll(':','').replaceAll('.','')+'.xlsx'
      let gerou = false;

      if(tipo == "Cotacoes"){

          logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
          const cotacoes =  await database('pedidocotacao')
          .select('numero_cotacao as NÚMERO DA COTAÇÃO',
          'dataCriacao as DATA DO PEDIDO',
          'statusPedido as ESTADO',
          'valorTotal as VALOR TOTAL',
          'descricaoPedido as DESCRIÇÃO',
          'quantidade as UNIDADES')
          .where({empresaID: empresa})
          .andWhere({clienteIdPedido: cliente})
          .andWhereILike('numero_cotacao', `%${campos.numero_cotacao}%`)
          .andWhereILike('valorTotal', `%${campos.valorTotal}%`)
          // .andWhereILike('descricaoPedido', `%${campos.descricaoPedido}%`)
          .andWhereILike('quantidade', `%${campos.quantidade}%`)
          .andWhereILike('statusPedido', `%${campos.statusPedido}%`)
          .andWhereBetween("dataCriacao", [campos.data_inicio, campos.data_final])
          .orderBy('pedidoCotacaoId','desc')

          console.log(cotacoes)

          
          logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
          cotacoes.map(function(fn){
            // fn["CRIAÇÃO"] = new Date(fn["CRIAÇÃO"]).toLocaleString()
            fn["DATA DO PEDIDO"] = new Date(fn["DATA DO PEDIDO"]).toLocaleDateString()
            fn["VALOR TOTAL"] = Intl.NumberFormat("PT-br").format(fn["VALOR TOTAL"])
            
            return fn
          })
          
          if(cotacoes.length) {
            gerou = true
            logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
            await database('relatorios').insert({para: tipo, file_gerado: filename, empresaRelatorio: empresa, clienteRelatorio: cliente});
          }

          const text = cotacoes.length ? "Relatorio gerado com sucesso" : "Sem registros para gerar"
          
          logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
          const rs = response("sucesso", 201, {tipo, cotacoes, filename, text});
          return rs
          

        }

      if(tipo == "Facturas"){

          logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
          const facturas =  await database('factura')
          .select('numeroFactura as NÚMERO DA FACTURA',
          'dataEmissao as DATA DE EMISSÃO',
          'dataVencimento as DATA DE VENCIMENTO',
          'dataPagamento as DATA DA LIQUIDAÇÃO',
          'formaPagamento as MOTODO DE PAGAMENTO',
          'valorTotalFactura as VALOR TOTAL',
          'descricao as DESCRIÇÃO',
          'statusFactura as ESTADO')
          .where({empresaIdFac: empresa})
          .andWhere({clienteIdFac: cliente})
          .andWhereILike('numeroFactura', `%${campos.numeroFactura}%`)
          .andWhereILike('valorTotalFactura', `%${campos.valorTotal}%`)
          .andWhereILike('dataPagamento', `%${campos.dataPagamento}%`)
          .andWhereILike('dataVencimento', `%${campos.dataVencimento}%`)
          .andWhereILike('statusFactura', `%${campos.statusFactura}%`)
          .andWhereBetween("dataEmissao", [campos.data_inicio, campos.data_final])
          .orderBy('facturaId','desc')
          
          logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
          facturas.map(function(fn){
            fn["DATA DE EMISSÃO"] = new Date(fn["DATA DE EMISSÃO"]).toLocaleDateString()
            fn["DATA DE VENCIMENTO"] = new Date(fn["DATA DE VENCIMENTO"]).toLocaleDateString()
            fn["DATA DA LIQUIDAÇÃO"] = new Date(fn["DATA DA LIQUIDAÇÃO"]).toLocaleDateString()
            fn["VALOR TOTAL"] = Intl.NumberFormat("PT-br").format(fn["VALOR TOTAL"])
            
            return fn
          })
          
          if(facturas.length) {
            gerou = true
            logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
            await database('relatorios').insert({para: tipo, file_gerado: filename, empresaRelatorio: empresa, clienteRelatorio: cliente});
          }

          const text = facturas.length ? "Relatorio gerado com sucesso" : "Sem registros para gerar"
          
          logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
          const rs = response("sucesso", 201, {tipo, facturas, filename, text});
          return rs
          

        }

      if(tipo == "Movimentos"){

          logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
          const movimentos =  await database('movimento_financeiro')
          .select(
          'valor as VALOR TOTAL',
          'descricao as DESCRIÇÃO',
          'dataMovimento as DATA DO MOVIMENTO',
          'tipoMovimento as ESTADO')
          .where({empresaIdMov: empresa})
          .andWhere({clienteIdMov: cliente})
          .andWhereILike('valor', `%${campos.valor}%`)
          .andWhereILike('descricao', `%${campos.descricao}%`)
          .andWhereILike('tipoMovimento', `%${campos.tipoMovimento}%`)
          .andWhereBetween("dataMovimento", [campos.data_inicio, campos.data_final])
          .orderBy('movimentoFinanceiroId','desc')
          
          console.log(movimentos)
          console.log(campos)
          
          logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
          movimentos.map(function(fn){
            fn["DATA DO MOVIMENTO"] = new Date(fn["DATA DO MOVIMENTO"]).toLocaleDateString()
            fn["VALOR TOTAL"] = Intl.NumberFormat("PT-br").format(fn["VALOR TOTAL"])
            
            return fn
          })
          
          if(movimentos.length) {
            gerou = true
            logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
            await database('relatorios').insert({para: tipo, file_gerado: filename, empresaRelatorio: empresa, clienteRelatorio: cliente});
          }

          const text = movimentos.length ? "Relatorio gerado com sucesso" : "Sem registros para gerar"
          
          logger("SERVIDOR:Clientes").info("Respondeu a solicitação")
          const rs = response("sucesso", 201, {tipo, movimentos, filename, text});
          return rs
          

        }

      
  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar cliente ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
    
}

module.exports.deleteRelatorios = async function (id_relatorio, req) {
  try {

      logger("SERVIDOR:deleteRelatorios").debug("Buscar os afiliados no banco de dados");
      const file = await database("relatorios").where({ id_relatorio })

      if (file.length == 0) {
        logger("SERVIDOR:deleteRelatorios").info("arquivo não encontrado")
        const rs = response("erro", 409, "arquivo não encontrado");
        return rs
      } 

      const existsFile = fs.existsSync(path.join(__dirname, "../reports", file[0].file_gerado))
      if(existsFile){
        fs.unlinkSync(path.join(__dirname, "../reports", file[0].file_gerado));
      }
      
      await database("relatorios").where({ id_relatorio }).del();
      
      logger("SERVIDOR:deleteRelatorios").info("Arquivo excluido feita com sucesso");
      const rs = response("sucesso", 202, "Arquivo excluido feita com sucesso", 'json', {
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "RELATORIOS", informacao: {id_relatorio, ...file[0]}}
      });

      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:deleteRelatorios").error(`Erro ao buscar cliente ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }

};
