const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getServicos = async function(pagina, limite, total_registros, titulo, descricao_curta, descricao_longa, status, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const servicos = await database("servicos")
      .whereLike("titulo",`%${titulo}%`)
      .whereLike("descricao_curta",`%${descricao_curta}%`)
      .whereLike("descricao_longa",`%${descricao_longa}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_criacao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_servicos", "DESC");

      const {registros} = paginationRecords(servicos, pagina, limite)

      const servicosLimite = await database("servicos")
      .whereLike("titulo",`%${titulo}%`)
      .whereLike("descricao_curta",`%${descricao_curta}%`)
      .whereLike("descricao_longa",`%${descricao_longa}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_criacao",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_servicos", "DESC");

      const filtered = usuariosFilteres(servicosLimite)
      
      registros.total_apresentados = servicosLimite.length
      registros.nome = titulo
      registros.email = descricao_longa
      registros.cargo = descricao_curta
      registros.status = status
      registros.criacao = data_criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getServicosId = async function(id_servicos) {
  try {

      const servicos = await database("servicos")
      .where({ id_servicos })
      .orderBy("id_servicos", "DESC");

      const [filtered] = usuariosFilteres(servicos)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postServicos = async function(dados, req) {
  try {

      const resultTipoReg = await database("servicos").where({
        descricao_longa: dados.descricao_longa,
        descricao_curta: dados.descricao_curta
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Email já cadastrado!`)
        const rs = response("erro", 409, "Email já cadastrado!");
        return rs
      }

      const resultTelefone = await database("servicos").where({
        titulo: dados.titulo
      });

      if (resultTelefone.length > 0){
        logger("SERVIDOR:postClientes").info(`Telefone já cadastrado!`)
        const rs = response("erro", 409, "Telefone já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("servicos").insert(dados);
      logger("SERVIDOR:Clientes").info(`Servicos cadastrado com sucesso`)
      const rs = response("sucesso", 201, "Servicos cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchServicos = async function(id_servicos, dados, req) {
  try {

      const result = await database("servicos")
      .where({id_servicos});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("Servicos não encontrados")
        const rs = response("erro", 403, "Servicos não encontrados");
        return rs

      }

      await database("servicos")
        .where({ id_servicos })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_servicos, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteServicos = async function(id_servicos, req) {
  try {

      const dados = await database("servicos").where({ id_servicos })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("Servicos não encontrados")
        const rs = response("erro", 403, "Servicos não encontrados");
        return rs

      }

      await database("servicos").where({ id_servicos }).del();

      logger("SERVIDOR:loginClientes").info("Servicos excluido feita com sucesso") 
      const rs = response("sucesso", 202, "Servicos excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_servicos, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
