const database = require('../config/database')
const bcrypt = require('bcryptjs');
const { v4: uuidv4 } = require('uuid');
const response = require("../constants/response");
const logger = require('../services/loggerService');
const pagination = require("../constants/pagination");
const paginationRecords = require("../helpers/paginationRecords");
const { usuariosFilteres } = require('../helpers/filterResponseSQL');

module.exports.getSolicitacoesImprensa = async function(pagina, limite, total_registros, nome, email, telefone, veiculo_comunicacao, necessidade, status, data_criacao) {
  try {

      logger("SERVIDOR:Clientes").debug("Selecionar da base de dados")
      const solicitacoes_imprensa = await database("solicitacoes_imprensa")
      .whereLike("nome",`%${nome}%`)
      .whereLike("veiculo_comunicacao",`%${veiculo_comunicacao}%`)
      .whereLike("necessidade",`%${necessidade}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_envio",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_solicitacoes_imprensa", "DESC");

      const {registros} = paginationRecords(solicitacoes_imprensa, pagina, limite)

      const solicitacoes_imprensaLimite = await database("solicitacoes_imprensa")
      .whereLike("nome",`%${nome}%`)
      .whereLike("veiculo_comunicacao",`%${veiculo_comunicacao}%`)
      .whereLike("necessidade",`%${necessidade}%`)
      .whereLike("email",`%${email}%`)
      .whereLike("telefone",`%${telefone}%`)
      .whereLike("status",`%${status}%`)
      .whereLike("data_envio",`%${data_criacao}%`)
      .limit(total_registros || pagination.total_limite)
      .orderBy("id_solicitacoes_imprensa", "DESC");

      const filtered = usuariosFilteres(solicitacoes_imprensaLimite)
      
      registros.total_apresentados = solicitacoes_imprensaLimite.length
      registros.nome = nome
      registros.email = email
      registros.necessidade = necessidade
      registros.veiculo_comunicacao =  veiculo_comunicacao
      registros.status = status
      registros.telefone = telefone
      registros.criacao = data_criacao

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered, 'json', {registros})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.getSolicitacoesImprensaId = async function(id_solicitacoes_imprensa) {
  try {

      const solicitacoes_imprensa = await database("solicitacoes_imprensa")
      .where({ id_solicitacoes_imprensa })
      .orderBy("id_solicitacoes_imprensa", "DESC");

      const [filtered] = usuariosFilteres(solicitacoes_imprensa)

      logger("SERVIDOR:getAfiliados").info("Respondeu a requisição");
      const rs = response("sucesso", 200, filtered || {})
      return rs;

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.postSolicitacoesImprensa = async function(dados, req) {
  try {

      const resultTipoReg = await database("solicitacoes_imprensa").where({
        email: dados.email,
        necessidade: dados.necessidade,
        veiculo_comunicacao: dados.veiculo_comunicacao
      });

      if (resultTipoReg.length > 0){
        logger("SERVIDOR:postClientes").info(`Registro já cadastrado!`)
        const rs = response("erro", 409, "Registro já cadastrado!");
        return rs
      }

      logger("SERVIDOR:Clientes").debug(`Entidade criada com sucesso`)
      await database("solicitacoes_imprensa").insert(dados);
      logger("SERVIDOR:Clientes").info(`SolicitacoesImprensa cadastrado com sucesso`)
      const rs = response("sucesso", 201, "SolicitacoesImprensa cadastrado com sucesso","json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: dados, entidade: "01157"}
      });

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};


module.exports.patchSolicitacoesImprensa = async function(id_solicitacoes_imprensa, dados, req) {
  try {

      const result = await database("solicitacoes_imprensa")
      .where({id_solicitacoes_imprensa});

      if (result.length == 0) {

        logger("SERVIDOR:loginClientes").info("SolicitacoesImprensa não encontrados")
        const rs = response("erro", 403, "SolicitacoesImprensa não encontrados");
        return rs

      }

      await database("solicitacoes_imprensa")
        .where({ id_solicitacoes_imprensa })
        .update({ ...dados });
      
      logger("SERVIDOR:loginClientes").info("Actualização feita com sucesso") 
      const rs = response("sucesso", 202, "Actualização feita com sucesso", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_solicitacoes_imprensa, ...dados}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};

module.exports.deleteSolicitacoesImprensa = async function(id_solicitacoes_imprensa, req) {
  try {

      const dados = await database("solicitacoes_imprensa").where({ id_solicitacoes_imprensa })

      if (dados.length == 0) {

        logger("SERVIDOR:loginClientes").info("SolicitacoesImprensa não encontrados")
        const rs = response("erro", 403, "SolicitacoesImprensa não encontrados");
        return rs

      }

      await database("solicitacoes_imprensa").where({ id_solicitacoes_imprensa }).del();

      logger("SERVIDOR:loginClientes").info("SolicitacoesImprensa excluido feita com sucesso") 
      const rs = response("sucesso", 202, "SolicitacoesImprensa excluido feita com sucessoo", "json",{
        logs: {ip: req.ip, verbo_rota_API: req.method, rota_API: req.originalUrl, tipo: "DEFAULT" , tabela: "USUARIOS", informacao: {id_solicitacoes_imprensa, ...dados[0]}, entidade: "01157"}
      })

      return rs

  } catch (error) {
      console.log(error)
      logger("SERVIDOR:Clientes").error(`Erro ao buscar clientes ${error.message}`)
      const rs = response("erro", 400, 'Algo aconteceu. Tente de novo');
      return rs
  }
};
