const express = require('express');
const router = express.Router();
const controller = require('../controllers/facturas');

/* GET Factura listing. */
router.get('/', controller.getFactura);

router.get('/:facturaId', controller.getFacturaId);

router.get('/clienteId/:clienteId', controller.getFacturaclienteId);

router.get('/periodo/:periodo', controller.getFacturaPeriodo);

router.get('/entidade/:empresaId', controller.getFacturaEntidade);

router.get('/entidade/:empresaId/periodo/:periodo', controller.getFacturaEntidadePeriodo);

router.get('/entidade/:empresaId/clienteId/:clienteId', controller.getFacturaEntidadeclienteId);

router.get('/entidade/:empresaId/grupo/:grupo_identificacao', controller.getFacturaEntidadeGrupoAfiliados);

router.get('/entidade/:empresaId/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getFacturaEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getFacturaDias);

// POST
router.post('/pagar', controller.postPagarFacturas);

module.exports = router;