const express = require('express');
const router = express.Router();
const controller = require('../controllers/pagamentos');

/* GET pagamentos listing. */
router.get('/', controller.getPagamentos);

router.get('/:id_pagamento', controller.getPagamentosId);

router.get('/clienteId/:clienteId', controller.getPagamentosclienteId);

router.get('/periodo/:periodo', controller.getPagamentosPeriodo);

router.get('/entidade/:empresaId', controller.getPagamentosEntidade);

router.get('/entidade/:empresaId/periodo/:periodo', controller.getPagamentosEntidadePeriodo);

router.get('/entidade/:empresaId/clienteId/:clienteId', controller.getPagamentosEntidadeclienteId);

router.get('/entidade/:empresaId/grupo/:grupo_identificacao', controller.getPagamentosEntidadeGrupoAfiliados);

router.get('/entidade/:empresaId/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPagamentosEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getPagamentosDias);

// POST

router.post("/pagamento-webhook", controller.postPagamentoWebhook)

module.exports = router;