const express = require('express');
const router = express.Router();
const controller = require('../controllers/produtos');

/* GET Produtos listing. */
router.get('/', controller.getProdutos);

router.get('/:ProdutosId', controller.getProdutosId);

router.get('/clienteId/:clienteId', controller.getProdutosclienteId);

router.get('/periodo/:periodo', controller.getProdutosPeriodo);

router.get('/entidade/:empresaId', controller.getProdutosEntidade);

router.get('/entidade/:empresaId/periodo/:periodo', controller.getProdutosEntidadePeriodo);

router.get('/entidade/:empresaId/clienteId/:clienteId', controller.getProdutosEntidadeclienteId);

router.get('/entidade/:empresaId/grupo/:grupo_identificacao', controller.getProdutosEntidadeGrupoAfiliados);

router.get('/entidade/:empresaId/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getProdutosEntidadeDias);

router.get('/dia-inicio/:dia_inicio/dia-final/:dia_final', controller.getProdutosDias);

module.exports = router;