const express = require('express');
const router = express.Router();
const controller = require('../controllers/relatorios');

/* GET relatorios listing. */
router.get('/', controller.getRelatorios);

router.get('/:id_relatorio', controller.getRelatoriosId);

router.get('/entidade/:entidade/clienteId/:clienteId', controller.getRelatoriosEntidade);

router.get('/entidade/:entidade/clienteId/:clienteId/tipo/:tipo', controller.getRelatoriosEntidadeEmpresaTipo);

router.get('/entidade/:entidade/tipo/:tipo', controller.getRelatoriosEntidadeTipo);

/* GET relatorios listing. */
router.post('/', controller.postRelatorios);

/* GET relatorios listing. */
router.delete('/:id_relatorio', controller.deleteRelatorios)



module.exports = router;